package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class ServiceEntrySpecFluentImpl<A extends io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent<A>{
  public ServiceEntrySpecFluentImpl() {
  }
  public ServiceEntrySpecFluentImpl(io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpec instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.withExportTo(instance.getExportTo()); 
    this.withHosts(instance.getHosts()); 
    this.withLocation(instance.getLocation()); 
    this.withPorts(instance.getPorts()); 
    this.withResolution(instance.getResolution()); 
    this.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.withWorkloadSelector(instance.getWorkloadSelector()); 
  }
  private java.util.List<java.lang.String> addresses;
  private java.util.List<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder> endpoints;
  private java.util.List<java.lang.String> exportTo;
  private java.util.List<java.lang.String> hosts;
  private io.fabric8.istio.api.networking.v1alpha3.ServiceEntryLocation location;
  private java.util.List<io.fabric8.istio.api.networking.v1alpha3.PortBuilder> ports;
  private io.fabric8.istio.api.networking.v1alpha3.ServiceEntryResolution resolution;
  private java.util.List<java.lang.String> subjectAltNames;
  private io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder workloadSelector;
  public A addToAddresses(java.lang.Integer index,java.lang.String item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  public A setToAddresses(java.lang.Integer index,java.lang.String item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    this.addresses.set(index, item); return (A)this;
  }
  public A addToAddresses(java.lang.String... items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A addAllToAddresses(java.util.Collection<java.lang.String> items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A removeFromAddresses(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public A removeAllFromAddresses(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAddresses() {
    return this.addresses;
  }
  public java.lang.String getAddress(java.lang.Integer index) {
    return this.addresses.get(index);
  }
  public java.lang.String getFirstAddress() {
    return this.addresses.get(0);
  }
  public java.lang.String getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  public java.lang.String getMatchingAddress(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: addresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(java.util.List<java.lang.String> addresses) {
    if (addresses != null) {this.addresses = new java.util.ArrayList(); for (java.lang.String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(java.lang.String... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (java.lang.String item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(java.lang.String arg0) {
    return (A)addToAddresses(new String(arg0));
  }
  public A addToEndpoints(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder>();}
    io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
  }
  public A setToEndpoints(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder>();}
    io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(item);
    if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
    if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
     return (A)this;
  }
  public A addToEndpoints(io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec... items) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder>();}
    for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item : items) {io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A addAllToEndpoints(java.util.Collection<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec> items) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder>();}
    for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item : items) {io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A removeFromEndpoints(io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec... items) {
    for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item : items) {io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpoints(java.util.Collection<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec> items) {
    for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item : items) {io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpoints(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec> getEndpoints() {
    return build(endpoints);
  }
  public java.util.List<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec> buildEndpoints() {
    return build(endpoints);
  }
  public io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec buildEndpoint(java.lang.Integer index) {
    return this.endpoints.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec buildMatchingEndpoint(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingEndpoint(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpoints(java.util.List<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec> endpoints) {
    if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
    if (endpoints != null) {this.endpoints = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
  }
  public A withEndpoints(io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec... endpoints) {
    if (this.endpoints != null) {this.endpoints.clear();}
    if (endpoints != null) {for (io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item :endpoints){ this.addToEndpoints(item);}} return (A) this;
  }
  public java.lang.Boolean hasEndpoints() {
    return endpoints != null && !endpoints.isEmpty();
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint() {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.EndpointsNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.EndpointsNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.EndpointsNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(java.lang.Integer index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public A addToExportTo(java.lang.Integer index,java.lang.String item) {
    if (this.exportTo == null) {this.exportTo = new java.util.ArrayList<java.lang.String>();}
    this.exportTo.add(index, item);
    return (A)this;
  }
  public A setToExportTo(java.lang.Integer index,java.lang.String item) {
    if (this.exportTo == null) {this.exportTo = new java.util.ArrayList<java.lang.String>();}
    this.exportTo.set(index, item); return (A)this;
  }
  public A addToExportTo(java.lang.String... items) {
    if (this.exportTo == null) {this.exportTo = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A addAllToExportTo(java.util.Collection<java.lang.String> items) {
    if (this.exportTo == null) {this.exportTo = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A removeFromExportTo(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
  }
  public A removeAllFromExportTo(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getExportTo() {
    return this.exportTo;
  }
  public java.lang.String getExportTo(java.lang.Integer index) {
    return this.exportTo.get(index);
  }
  public java.lang.String getFirstExportTo() {
    return this.exportTo.get(0);
  }
  public java.lang.String getLastExportTo() {
    return this.exportTo.get(exportTo.size() - 1);
  }
  public java.lang.String getMatchingExportTo(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: exportTo) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingExportTo(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: exportTo) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExportTo(java.util.List<java.lang.String> exportTo) {
    if (exportTo != null) {this.exportTo = new java.util.ArrayList(); for (java.lang.String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
  }
  public A withExportTo(java.lang.String... exportTo) {
    if (this.exportTo != null) {this.exportTo.clear();}
    if (exportTo != null) {for (java.lang.String item :exportTo){ this.addToExportTo(item);}} return (A) this;
  }
  public java.lang.Boolean hasExportTo() {
    return exportTo != null && !exportTo.isEmpty();
  }
  public A addNewExportTo(java.lang.String arg0) {
    return (A)addToExportTo(new String(arg0));
  }
  public A addToHosts(java.lang.Integer index,java.lang.String item) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(java.lang.Integer index,java.lang.String item) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(java.util.Collection<java.lang.String> items) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public A removeAllFromHosts(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getHosts() {
    return this.hosts;
  }
  public java.lang.String getHost(java.lang.Integer index) {
    return this.hosts.get(index);
  }
  public java.lang.String getFirstHost() {
    return this.hosts.get(0);
  }
  public java.lang.String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public java.lang.String getMatchingHost(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingHost(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(java.util.List<java.lang.String> hosts) {
    if (hosts != null) {this.hosts = new java.util.ArrayList(); for (java.lang.String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (java.lang.String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public java.lang.Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public A addNewHost(java.lang.String arg0) {
    return (A)addToHosts(new String(arg0));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntryLocation getLocation() {
    return this.location;
  }
  public A withLocation(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryLocation location) {
    this.location=location; return (A) this;
  }
  public java.lang.Boolean hasLocation() {
    return this.location != null;
  }
  public A addToPorts(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Port item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.PortBuilder>();}
    io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Port item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.PortBuilder>();}
    io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.istio.api.networking.v1alpha3.Port... items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.PortBuilder>();}
    for (io.fabric8.istio.api.networking.v1alpha3.Port item : items) {io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(java.util.Collection<io.fabric8.istio.api.networking.v1alpha3.Port> items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.PortBuilder>();}
    for (io.fabric8.istio.api.networking.v1alpha3.Port item : items) {io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.istio.api.networking.v1alpha3.Port... items) {
    for (io.fabric8.istio.api.networking.v1alpha3.Port item : items) {io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(java.util.Collection<io.fabric8.istio.api.networking.v1alpha3.Port> items) {
    for (io.fabric8.istio.api.networking.v1alpha3.Port item : items) {io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.PortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1alpha3.PortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.istio.api.networking.v1alpha3.Port> getPorts() {
    return build(ports);
  }
  public java.util.List<io.fabric8.istio.api.networking.v1alpha3.Port> buildPorts() {
    return build(ports);
  }
  public io.fabric8.istio.api.networking.v1alpha3.Port buildPort(java.lang.Integer index) {
    return this.ports.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.Port buildFirstPort() {
    return this.ports.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.Port buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.Port buildMatchingPort(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.PortBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1alpha3.PortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.PortBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1alpha3.PortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(java.util.List<io.fabric8.istio.api.networking.v1alpha3.Port> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1alpha3.Port item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.istio.api.networking.v1alpha3.Port... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (io.fabric8.istio.api.networking.v1alpha3.Port item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public java.lang.Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(java.lang.String name,java.lang.Integer number,java.lang.String protocol,java.lang.Integer targetPort) {
    return (A)addToPorts(new Port(name, number, protocol, targetPort));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> addNewPort() {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.PortsNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(io.fabric8.istio.api.networking.v1alpha3.Port item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.PortsNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Port item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.PortsNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> editPort(java.lang.Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.PortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntryResolution getResolution() {
    return this.resolution;
  }
  public A withResolution(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryResolution resolution) {
    this.resolution=resolution; return (A) this;
  }
  public java.lang.Boolean hasResolution() {
    return this.resolution != null;
  }
  public A addToSubjectAltNames(java.lang.Integer index,java.lang.String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    this.subjectAltNames.add(index, item);
    return (A)this;
  }
  public A setToSubjectAltNames(java.lang.Integer index,java.lang.String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    this.subjectAltNames.set(index, item); return (A)this;
  }
  public A addToSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A addAllToSubjectAltNames(java.util.Collection<java.lang.String> items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A removeFromSubjectAltNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public A removeAllFromSubjectAltNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getSubjectAltNames() {
    return this.subjectAltNames;
  }
  public java.lang.String getSubjectAltName(java.lang.Integer index) {
    return this.subjectAltNames.get(index);
  }
  public java.lang.String getFirstSubjectAltName() {
    return this.subjectAltNames.get(0);
  }
  public java.lang.String getLastSubjectAltName() {
    return this.subjectAltNames.get(subjectAltNames.size() - 1);
  }
  public java.lang.String getMatchingSubjectAltName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: subjectAltNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingSubjectAltName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: subjectAltNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjectAltNames(java.util.List<java.lang.String> subjectAltNames) {
    if (subjectAltNames != null) {this.subjectAltNames = new java.util.ArrayList(); for (java.lang.String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
  }
  public A withSubjectAltNames(java.lang.String... subjectAltNames) {
    if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
    if (subjectAltNames != null) {for (java.lang.String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubjectAltNames() {
    return subjectAltNames != null && !subjectAltNames.isEmpty();
  }
  public A addNewSubjectAltName(java.lang.String arg0) {
    return (A)addToSubjectAltNames(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildWorkloadSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector getWorkloadSelector() {
    return this.workloadSelector!=null?this.workloadSelector.build():null;
  }
  public io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector buildWorkloadSelector() {
    return this.workloadSelector!=null?this.workloadSelector.build():null;
  }
  public A withWorkloadSelector(io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector workloadSelector) {
    _visitables.get("workloadSelector").remove(this.workloadSelector);
    if (workloadSelector!=null){ this.workloadSelector= new io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} return (A) this;
  }
  public java.lang.Boolean hasWorkloadSelector() {
    return this.workloadSelector != null;
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector() {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.WorkloadSelectorNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluentImpl.WorkloadSelectorNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<A> editWorkloadSelector() {
    return withNewWorkloadSelectorLike(getWorkloadSelector());
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
    return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector item) {
    return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceEntrySpecFluentImpl that = (ServiceEntrySpecFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    if (exportTo != null ? !exportTo.equals(that.exportTo) :that.exportTo != null) return false;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (location != null ? !location.equals(that.location) :that.location != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (resolution != null ? !resolution.equals(that.resolution) :that.resolution != null) return false;
    if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
    if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  endpoints,  exportTo,  hosts,  location,  ports,  resolution,  subjectAltNames,  workloadSelector,  super.hashCode());
  }
  public class EndpointsNestedImpl<N> extends io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecFluentImpl<io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<N>> implements io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointsNestedImpl(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec item) {
      this.index = index;
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder(this);
    }
    io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ServiceEntrySpecFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint() {
      return and();
    }
    
  }
  public class PortsNestedImpl<N> extends io.fabric8.istio.api.networking.v1alpha3.PortFluentImpl<io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<N>> implements io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortsNestedImpl(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Port item) {
      this.index = index;
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(this);
    }
    io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ServiceEntrySpecFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  public class WorkloadSelectorNestedImpl<N> extends io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorFluentImpl<io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<N>> implements io.fabric8.istio.api.networking.v1alpha3.ServiceEntrySpecFluent.WorkloadSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    WorkloadSelectorNestedImpl(io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector item) {
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder(this);
    }
    io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder builder;
    public N and() {
      return (N) ServiceEntrySpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector() {
      return and();
    }
    
  }
  
}