package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LoadBalancerSettingsBuilder extends io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluentImpl<io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings,io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsBuilder>{
  public LoadBalancerSettingsBuilder() {
    this(false);
  }
  public LoadBalancerSettingsBuilder(java.lang.Boolean validationEnabled) {
    this(new LoadBalancerSettings(), validationEnabled);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LoadBalancerSettings(), validationEnabled);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLbPolicy(instance.getLbPolicy()); 
    fluent.withLocalityLbSetting(instance.getLocalityLbSetting()); 
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings instance) {
    this(instance,false);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLbPolicy(instance.getLbPolicy()); 
    this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings build() {
    LoadBalancerSettings buildable = new LoadBalancerSettings(fluent.getLbPolicy(),fluent.getLocalityLbSetting());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LoadBalancerSettingsBuilder that = (LoadBalancerSettingsBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}