package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class GatewaySpecFluentImpl<A extends io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent<A>{
  public GatewaySpecFluentImpl() {
  }
  public GatewaySpecFluentImpl(io.fabric8.istio.api.networking.v1alpha3.GatewaySpec instance) {
    this.withSelector(instance.getSelector()); 
    this.withServers(instance.getServers()); 
  }
  private java.util.Map<java.lang.String,java.lang.String> selector;
  private java.util.List<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder> servers;
  public A addToSelector(java.lang.String key,java.lang.String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null && map != null) { this.selector = new java.util.LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(java.lang.String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new java.util.LinkedHashMap(selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public A addToServers(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Server item) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder>();}
    io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(item);_visitables.get("servers").add(index >= 0 ? index : _visitables.get("servers").size(), builder);this.servers.add(index >= 0 ? index : servers.size(), builder); return (A)this;
  }
  public A setToServers(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Server item) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder>();}
    io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(item);
    if (index < 0 || index >= _visitables.get("servers").size()) { _visitables.get("servers").add(builder); } else { _visitables.get("servers").set(index, builder);}
    if (index < 0 || index >= servers.size()) { servers.add(builder); } else { servers.set(index, builder);}
     return (A)this;
  }
  public A addToServers(io.fabric8.istio.api.networking.v1alpha3.Server... items) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder>();}
    for (io.fabric8.istio.api.networking.v1alpha3.Server item : items) {io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A addAllToServers(java.util.Collection<io.fabric8.istio.api.networking.v1alpha3.Server> items) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder>();}
    for (io.fabric8.istio.api.networking.v1alpha3.Server item : items) {io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A removeFromServers(io.fabric8.istio.api.networking.v1alpha3.Server... items) {
    for (io.fabric8.istio.api.networking.v1alpha3.Server item : items) {io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeAllFromServers(java.util.Collection<io.fabric8.istio.api.networking.v1alpha3.Server> items) {
    for (io.fabric8.istio.api.networking.v1alpha3.Server item : items) {io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServers(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.istio.api.networking.v1alpha3.Server> getServers() {
    return build(servers);
  }
  public java.util.List<io.fabric8.istio.api.networking.v1alpha3.Server> buildServers() {
    return build(servers);
  }
  public io.fabric8.istio.api.networking.v1alpha3.Server buildServer(java.lang.Integer index) {
    return this.servers.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1alpha3.Server buildMatchingServer(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1alpha3.ServerBuilder item: servers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServer(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1alpha3.ServerBuilder item: servers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServers(java.util.List<io.fabric8.istio.api.networking.v1alpha3.Server> servers) {
    if (this.servers != null) { _visitables.get("servers").removeAll(this.servers);}
    if (servers != null) {this.servers = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1alpha3.Server item : servers){this.addToServers(item);}} else { this.servers = null;} return (A) this;
  }
  public A withServers(io.fabric8.istio.api.networking.v1alpha3.Server... servers) {
    if (this.servers != null) {this.servers.clear();}
    if (servers != null) {for (io.fabric8.istio.api.networking.v1alpha3.Server item :servers){ this.addToServers(item);}} return (A) this;
  }
  public java.lang.Boolean hasServers() {
    return servers != null && !servers.isEmpty();
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> addNewServer() {
    return new io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluentImpl.ServersNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> addNewServerLike(io.fabric8.istio.api.networking.v1alpha3.Server item) {
    return new io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluentImpl.ServersNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> setNewServerLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Server item) {
    return new io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluentImpl.ServersNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> editServer(java.lang.Integer index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  public io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<A> editMatchingServer(java.util.function.Predicate<io.fabric8.istio.api.networking.v1alpha3.ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GatewaySpecFluentImpl that = (GatewaySpecFluentImpl) o;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (servers != null ? !servers.equals(that.servers) :that.servers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(selector,  servers,  super.hashCode());
  }
  public class ServersNestedImpl<N> extends io.fabric8.istio.api.networking.v1alpha3.ServerFluentImpl<io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<N>> implements io.fabric8.istio.api.networking.v1alpha3.GatewaySpecFluent.ServersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServersNestedImpl(java.lang.Integer index,io.fabric8.istio.api.networking.v1alpha3.Server item) {
      this.index = index;
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(this, item);
    }
    ServersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.ServerBuilder(this);
    }
    io.fabric8.istio.api.networking.v1alpha3.ServerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) GatewaySpecFluentImpl.this.setToServers(index,builder.build());
    }
    public N endServer() {
      return and();
    }
    
  }
  
}