package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public class ServerFluentImpl<A extends io.fabric8.istio.api.networking.v1alpha3.ServerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.istio.api.networking.v1alpha3.ServerFluent<A>{
  public ServerFluentImpl() {
  }
  public ServerFluentImpl(io.fabric8.istio.api.networking.v1alpha3.Server instance) {
    this.withBind(instance.getBind()); 
    this.withDefaultEndpoint(instance.getDefaultEndpoint()); 
    this.withHosts(instance.getHosts()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withTls(instance.getTls()); 
  }
  private java.lang.String bind;
  private java.lang.String defaultEndpoint;
  private java.util.List<java.lang.String> hosts;
  private java.lang.String name;
  private io.fabric8.istio.api.networking.v1alpha3.PortBuilder port;
  private io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder tls;
  public java.lang.String getBind() {
    return this.bind;
  }
  public A withBind(java.lang.String bind) {
    this.bind=bind; return (A) this;
  }
  public java.lang.Boolean hasBind() {
    return this.bind != null;
  }
  
  /**
   * Method is deprecated. use withBind instead.
   */
  @java.lang.Deprecated
  public A withNewBind(java.lang.String arg0) {
    return (A)withBind(new String(arg0));
  }
  public java.lang.String getDefaultEndpoint() {
    return this.defaultEndpoint;
  }
  public A withDefaultEndpoint(java.lang.String defaultEndpoint) {
    this.defaultEndpoint=defaultEndpoint; return (A) this;
  }
  public java.lang.Boolean hasDefaultEndpoint() {
    return this.defaultEndpoint != null;
  }
  
  /**
   * Method is deprecated. use withDefaultEndpoint instead.
   */
  @java.lang.Deprecated
  public A withNewDefaultEndpoint(java.lang.String arg0) {
    return (A)withDefaultEndpoint(new String(arg0));
  }
  public A addToHosts(java.lang.Integer index,java.lang.String item) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(java.lang.Integer index,java.lang.String item) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(java.util.Collection<java.lang.String> items) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public A removeAllFromHosts(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getHosts() {
    return this.hosts;
  }
  public java.lang.String getHost(java.lang.Integer index) {
    return this.hosts.get(index);
  }
  public java.lang.String getFirstHost() {
    return this.hosts.get(0);
  }
  public java.lang.String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public java.lang.String getMatchingHost(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingHost(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(java.util.List<java.lang.String> hosts) {
    if (hosts != null) {this.hosts = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (java.lang.String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public java.lang.Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public A addNewHost(java.lang.String arg0) {
    return (A)addToHosts(new String(arg0));
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1alpha3.Port getPort() {
    return this.port!=null?this.port.build():null;
  }
  public io.fabric8.istio.api.networking.v1alpha3.Port buildPort() {
    return this.port!=null?this.port.build():null;
  }
  public A withPort(io.fabric8.istio.api.networking.v1alpha3.Port port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(java.lang.String name,java.lang.Integer number,java.lang.String protocol,java.lang.Integer targetPort) {
    return (A)withPort(new Port(name, number, protocol, targetPort));
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<A> withNewPort() {
    return new io.fabric8.istio.api.networking.v1alpha3.ServerFluentImpl.PortNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<A> withNewPortLike(io.fabric8.istio.api.networking.v1alpha3.Port item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServerFluentImpl.PortNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new io.fabric8.istio.api.networking.v1alpha3.PortBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<A> editOrNewPortLike(io.fabric8.istio.api.networking.v1alpha3.Port item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings getTls() {
    return this.tls!=null?this.tls.build():null;
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings buildTls() {
    return this.tls!=null?this.tls.build():null;
  }
  public A withTls(io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
  }
  public java.lang.Boolean hasTls() {
    return this.tls != null;
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<A> withNewTls() {
    return new io.fabric8.istio.api.networking.v1alpha3.ServerFluentImpl.TlsNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<A> withNewTlsLike(io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings item) {
    return new io.fabric8.istio.api.networking.v1alpha3.ServerFluentImpl.TlsNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<A> editTls() {
    return withNewTlsLike(getTls());
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<A> editOrNewTls() {
    return withNewTlsLike(getTls() != null ? getTls(): new io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<A> editOrNewTlsLike(io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings item) {
    return withNewTlsLike(getTls() != null ? getTls(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerFluentImpl that = (ServerFluentImpl) o;
    if (bind != null ? !bind.equals(that.bind) :that.bind != null) return false;
    if (defaultEndpoint != null ? !defaultEndpoint.equals(that.defaultEndpoint) :that.defaultEndpoint != null) return false;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bind,  defaultEndpoint,  hosts,  name,  port,  tls,  super.hashCode());
  }
  public class PortNestedImpl<N> extends io.fabric8.istio.api.networking.v1alpha3.PortFluentImpl<io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<N>> implements io.fabric8.istio.api.networking.v1alpha3.ServerFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortNestedImpl(io.fabric8.istio.api.networking.v1alpha3.Port item) {
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.PortBuilder(this);
    }
    io.fabric8.istio.api.networking.v1alpha3.PortBuilder builder;
    public N and() {
      return (N) ServerFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  public class TlsNestedImpl<N> extends io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsFluentImpl<io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<N>> implements io.fabric8.istio.api.networking.v1alpha3.ServerFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsNestedImpl(io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings item) {
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder(this, item);
    }
    TlsNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder(this);
    }
    io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder builder;
    public N and() {
      return (N) ServerFluentImpl.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}