/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.List;

public class Truncate
extends BuiltStatement {
    private final String keyspace;
    private final String table;

    Truncate(String keyspace, String table) {
        super(keyspace);
        this.keyspace = keyspace;
        this.table = table;
    }

    Truncate(TableMetadata table) {
        super(table);
        this.keyspace = table.getKeyspace().getName();
        this.table = table.getName();
    }

    @Override
    protected StringBuilder buildQueryString(List<ByteBuffer> variables) {
        StringBuilder builder = new StringBuilder();
        builder.append("TRUNCATE ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        return builder;
    }
}

