/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.impl.memory;

import com.datastax.driver.core.Session;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import gnu.trove.map.TLongDoubleMap;
import gnu.trove.map.hash.TLongDoubleHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.metrics.core.Counter;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.RawNumericMetric;

public class MemoryMetricsService
implements MetricsService {
    private static final ListenableFuture<Void> VOID_FUTURE = Futures.immediateFuture(null);
    private Map<String, TLongDoubleMap> storage = new HashMap<String, TLongDoubleMap>();
    Table<String, String, Long> counters = TreeBasedTable.create();

    @Override
    public void startUp(Session session) {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public void startUp(Map<String, String> params) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public ListenableFuture<Void> addData(RawNumericMetric data) {
        this.addMetric(data);
        return VOID_FUTURE;
    }

    @Override
    public ListenableFuture<Map<RawNumericMetric, Throwable>> addData(Set<RawNumericMetric> data) {
        for (RawNumericMetric metric : data) {
            this.addMetric(metric);
        }
        Map errors = Collections.emptyMap();
        return Futures.immediateFuture(errors);
    }

    private void addMetric(RawNumericMetric metric) {
        TLongDoubleMap map;
        String metricId = metric.getId();
        if (this.storage.containsKey(metricId)) {
            map = this.storage.get(metricId);
        } else {
            map = new TLongDoubleHashMap();
            this.storage.put(metricId, map);
        }
        map.put(metric.getTimestamp(), metric.getAvg());
    }

    @Override
    public ListenableFuture<Void> updateCounter(Counter counter) {
        Long value = (Long)this.counters.get((Object)counter.getGroup(), (Object)counter.getName());
        if (value == null) {
            this.counters.put((Object)counter.getGroup(), (Object)counter.getName(), (Object)counter.getValue());
        } else {
            this.counters.put((Object)counter.getGroup(), (Object)counter.getName(), (Object)(value + counter.getValue()));
        }
        return VOID_FUTURE;
    }

    @Override
    public ListenableFuture<Void> updateCounters(Collection<Counter> counters) {
        for (Counter counter : counters) {
            this.updateCounter(counter);
        }
        return VOID_FUTURE;
    }

    @Override
    public ListenableFuture<List<Counter>> findCounters(String group) {
        Map row = this.counters.row((Object)group);
        ArrayList<Counter> counters = new ArrayList<Counter>(row.size());
        for (Map.Entry entry : row.entrySet()) {
            counters.add(new Counter(group, (String)entry.getKey(), (Long)entry.getValue()));
        }
        return Futures.immediateFuture(counters);
    }

    @Override
    public ListenableFuture<List<Counter>> findCounters(String group, List<String> counterNames) {
        Map row = this.counters.row((Object)group);
        ArrayList<Counter> counters = new ArrayList<Counter>(counterNames.size());
        for (String name : counterNames) {
            Long value = (Long)row.get(name);
            if (value == null) continue;
            counters.add(new Counter(group, name, value));
        }
        return Futures.immediateFuture(counters);
    }

    @Override
    public ListenableFuture<List<RawNumericMetric>> findData(String bucket, String id, long start, long end) {
        return this.findData(id, start, end);
    }

    @Override
    public ListenableFuture<List<RawNumericMetric>> findData(String id, long start, long end) {
        ArrayList<RawNumericMetric> metrics = new ArrayList<RawNumericMetric>();
        if (this.storage.containsKey(id)) {
            TLongDoubleMap map = this.storage.get(id);
            for (long ts : map.keys()) {
                if (ts < start || ts > end) continue;
                RawNumericMetric metric = new RawNumericMetric(id, map.get(ts), ts);
                metrics.add(metric);
            }
        }
        return Futures.immediateFuture(metrics);
    }

    @Override
    public boolean idExists(String id) {
        return this.storage.containsKey(id);
    }

    @Override
    public List<String> listMetrics() {
        ArrayList<String> metrics = new ArrayList<String>(this.storage.keySet().size());
        metrics.addAll(this.storage.keySet());
        return metrics;
    }
}

