/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.log.service;

import io.fabric8.insight.log.LogFilter;
import io.fabric8.insight.log.LogResults;
import io.fabric8.insight.log.service.LogQueryMBean;
import io.fabric8.insight.log.service.Logs;
import io.fabric8.insight.log.service.support.MavenCoordinates;
import io.fabric8.insight.log.support.LogQuerySupport;
import io.fabric8.insight.log.support.Predicate;
import java.io.IOException;
import org.apache.karaf.shell.log.LruList;
import org.apache.karaf.shell.log.VmLogAppender;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQuery
extends LogQuerySupport
implements LogQueryMBean {
    private transient Logger LOG = LoggerFactory.getLogger(LogQuery.class);
    private BundleContext bundleContext;
    private VmLogAppender appender;
    private ServiceTracker serviceTracker;

    public LogQuery() {
        this.mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
    }

    public void init() throws Exception {
        if (this.bundleContext == null) {
            throw new IllegalArgumentException("No bundleContext injected!");
        }
        ServiceTrackerCustomizer customizer = null;
        this.serviceTracker = new ServiceTracker(this.bundleContext, "org.ops4j.pax.logging.spi.PaxAppender", customizer);
        this.serviceTracker.open();
    }

    public void destroy() throws Exception {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.serviceTracker = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public String getBundleMavenCoordinates(long bundleId) {
        return MavenCoordinates.getMavenCoordinates(bundleId);
    }

    @Override
    public LogResults getLogResults(int count) throws IOException {
        LogResults events = this.getLogEventList(count, null);
        return events;
    }

    @Override
    public LogResults queryLogResults(LogFilter filter) {
        Predicate<PaxLoggingEvent> predicate = Logs.createPredicate(filter);
        int count = -1;
        if (filter != null) {
            count = filter.getCount();
        }
        return this.getLogEventList(count, predicate);
    }

    public LogResults getLogEventList(int count, Predicate<PaxLoggingEvent> predicate) {
        LogResults answer = new LogResults();
        answer.setHost(this.getHostName());
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        VmLogAppender a = this.getAppender();
        if (a != null) {
            Iterable iterable;
            LruList events = a.getEvents();
            if (events != null && (iterable = events.getElements()) != null) {
                int matched = 0;
                for (PaxLoggingEvent event : iterable) {
                    long timestamp = event.getTimeStamp();
                    if (timestamp > to) {
                        to = timestamp;
                    }
                    if (timestamp < from) {
                        from = timestamp;
                    }
                    if (predicate != null && !predicate.matches(event)) continue;
                    answer.addEvent(Logs.newInstance(event));
                    if (count <= 0 || ++matched < count) continue;
                    break;
                }
            }
        } else {
            this.LOG.warn("No VmLogAppender available!");
        }
        answer.setFromTimestamp(from);
        answer.setToTimestamp(to);
        return answer;
    }

    public VmLogAppender getAppender() {
        Object[] services;
        if (this.appender == null && this.serviceTracker != null && (services = this.serviceTracker.getServices()) != null) {
            for (Object service : services) {
                if (!(service instanceof VmLogAppender)) continue;
                return (VmLogAppender)service;
            }
        }
        return this.appender;
    }

    public void setAppender(VmLogAppender appender) {
        this.appender = appender;
    }
}

