/**
 * Copyright (C) FuseSource, Inc.
 * http://fusesource.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.fabric8.insight.log.rest;

import java.util.ArrayList;
import java.util.List;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogResponseHits {
	private List<LogResponseHit> hits = new ArrayList<LogResponseHit>();

	@JsonCreator
	public LogResponseHits(@JsonProperty("hits") List<LogResponseHit> hits) {
		this.hits = hits;
	}

	public List<LogResponseHit> getHits() {
		return hits;
	}

	public void setHits(List<LogResponseHit> hits) {
		this.hits = hits;
	}

}
