/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.influxdb;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.insight.metrics.model.MBeanAttrResult;
import io.fabric8.insight.metrics.model.MBeanAttrsResult;
import io.fabric8.insight.metrics.model.MBeanOperResult;
import io.fabric8.insight.metrics.model.MBeanOpersResult;
import io.fabric8.insight.metrics.model.Metrics;
import io.fabric8.insight.metrics.model.MetricsStorageService;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.metrics.model.Request;
import io.fabric8.insight.metrics.model.Result;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Serie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.insight.influxdb.metrics", label="Fabric8 InfluxDB Metrics Storage", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={MetricsStorageService.class})
@Properties(value={@Property(name="service.ranking", intValue={1})})
public class InfluxDBMetricsStorage
extends AbstractComponent
implements MetricsStorageService {
    private static final transient Logger LOG = LoggerFactory.getLogger(InfluxDBMetricsStorage.class);
    @Reference(referenceInterface=InfluxDB.class)
    private ValidatingReference<InfluxDB> influxDB = new ValidatingReference();

    @Activate
    void activate() throws Exception {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() throws MBeanRegistrationException, InstanceNotFoundException {
        this.deactivateComponent();
    }

    public void store(String type, long timestamp, QueryResult queryResult) {
        this.assertValid();
        if (this.influxDB == null) {
            throw new IllegalStateException("No influxDB available!");
        }
        LinkedList<Serie> series = new LinkedList<Serie>();
        Map results = queryResult.getResults();
        if (results != null) {
            HashMap<String, Number> data = new HashMap<String, Number>();
            Set entries = results.entrySet();
            for (Map.Entry entry : entries) {
                MBeanAttrsResult attrsResult;
                List attrResults;
                String key = (String)entry.getKey();
                Result result = (Result)entry.getValue();
                if (result instanceof MBeanOpersResult) {
                    MBeanOpersResult opersResult = (MBeanOpersResult)result;
                    List operResults = opersResult.getResults();
                    if (operResults != null) {
                        for (MBeanOperResult operResult : operResults) {
                            Object value = operResult.getValue();
                            Double doubleValue = this.toDouble(value);
                            if (doubleValue == null) continue;
                            String id = Metrics.metricId((String)type, (Request)opersResult.getRequest());
                            data.put(id, doubleValue);
                        }
                    }
                } else if (result instanceof MBeanAttrsResult && (attrResults = (attrsResult = (MBeanAttrsResult)result).getResults()) != null) {
                    for (MBeanAttrResult attrResult : attrResults) {
                        Map attrs = attrResult.getAttrs();
                        if (attrs == null) continue;
                        Set attrEntries = attrs.entrySet();
                        for (Map.Entry attrEntry : attrEntries) {
                            String attributeName = (String)attrEntry.getKey();
                            Object value = attrEntry.getValue();
                            Double doubleValue = this.toDouble(value);
                            if (doubleValue == null) continue;
                            String id = Metrics.metricId((String)type, (Request)attrsResult.getRequest(), (String)attributeName);
                            data.put(id, doubleValue);
                        }
                    }
                }
                if (data.isEmpty()) continue;
                data.put("time", timestamp);
                series.add(new Serie.Builder("insight").columns(data.keySet().toArray(new String[data.size()])).values(data.values().toArray(new Object[data.size()])).build());
            }
            if (!series.isEmpty()) {
                ((InfluxDB)this.influxDB.get()).write("fabric", TimeUnit.MILLISECONDS, series.toArray(new Serie[series.size()]));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("added " + series.size() + " metrics");
                }
            }
        }
    }

    protected Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return null;
    }

    void bindInfluxDB(InfluxDB service) {
        this.influxDB.bind((Object)service);
    }

    void unbindInfluxDB(InfluxDB service) {
        this.influxDB.unbind((Object)service);
    }
}

