/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.influxdb;

import io.fabric8.api.FabricException;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.insight.influxdb.InfluxDBNode;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component
public class InfluxDBComponent
extends AbstractComponent
implements GroupListener<InfluxDBNode> {
    private static final String INFLUXDB_CLUSTER_PATH = "/fabric/registry/clusters/influxdb";
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private Group<InfluxDBNode> group;
    private InfluxDB influxDB;
    private ServiceRegistration<InfluxDB> registration;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    synchronized void deactivate() throws IOException {
        this.deactivateComponent();
        if (this.group != null) {
            this.group.close();
        }
        this.unregister();
    }

    private void activateInternal() {
        this.group = new ZooKeeperGroup((CuratorFramework)this.curator.get(), INFLUXDB_CLUSTER_PATH, InfluxDBNode.class);
        this.group.add((GroupListener)this);
        this.group.start();
    }

    public synchronized void groupEvent(Group<InfluxDBNode> group, GroupListener.GroupEvent event) {
        switch (event) {
            case CONNECTED: {
                InfluxDBNode master = (InfluxDBNode)group.master();
                if (master != null) {
                    try {
                        String url = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)master.getUrl());
                        this.influxDB = InfluxDBFactory.connect(url, "root", "root");
                        this.unregister();
                        this.registration = this.bundleContext.registerService(InfluxDB.class, (Object)this.influxDB, null);
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw FabricException.launderThrowable((Throwable)e);
                    }
                }
            }
            case CHANGED: {
                break;
            }
            case DISCONNECTED: {
                this.unregister();
            }
        }
    }

    private synchronized void unregister() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

