/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class Huffman {
    private static final int[] CODES = new int[]{67108794, 0x3FFFFBB, 67108796, 67108797, 67108798, 0x3FFFFBF, 67108800, 67108801, 67108802, 0x3FFFFC3, 67108804, 67108805, 67108806, 67108807, 67108808, 67108809, 67108810, 67108811, 0x3FFFFCC, 67108813, 67108814, 0x3FFFFCF, 67108816, 67108817, 67108818, 0x3FFFFD3, 67108820, 67108821, 67108822, 67108823, 67108824, 67108825, 6, 8188, 496, 16380, 32764, 30, 100, 8189, 1018, 497, 1019, 1020, 101, 102, 31, 7, 0, 1, 2, 8, 32, 33, 34, 35, 36, 37, 38, 236, 131068, 39, 32765, 1021, 32766, 103, 237, 238, 104, 239, 105, 106, 498, 240, 499, 500, 501, 107, 108, 241, 242, 502, 503, 109, 40, 243, 504, 505, 244, 506, 507, 2044, 67108826, 2045, 16381, 110, 262142, 9, 111, 10, 41, 11, 112, 42, 43, 12, 245, 246, 44, 45, 46, 13, 47, 508, 48, 49, 14, 113, 114, 115, 116, 117, 247, 131069, 4092, 131070, 4093, 67108827, 67108828, 0x3FFFFDD, 67108830, 0x3FFFFDF, 67108832, 67108833, 67108834, 0x3FFFFE3, 67108836, 67108837, 67108838, 67108839, 67108840, 67108841, 67108842, 67108843, 67108844, 67108845, 0x3FFFFEE, 0x3FFFFEF, 0x3FFFFF0, 0x3FFFFF1, 0x3FFFFF2, 0x3FFFFF3, 0x3FFFFF4, 0x3FFFFF5, 0x3FFFFF6, 0x3FFFFF7, 0x3FFFFF8, 0x3FFFFF9, 0x3FFFFFA, 0x3FFFFFB, 0x3FFFFFC, 0x3FFFFFD, 0x3FFFFFE, 0x3FFFFFF, 33554304, 0x1FFFF81, 33554306, 33554307, 33554308, 33554309, 33554310, 33554311, 0x1FFFF88, 33554313, 33554314, 33554315, 33554316, 33554317, 33554318, 0x1FFFF8F, 33554320, 0x1FFFF91, 33554322, 33554323, 33554324, 33554325, 33554326, 33554327, 33554328, 0x1FFFF99, 33554330, 33554331, 33554332, 33554333, 33554334, 0x1FFFF9F, 33554336, 0x1FFFFA1, 33554338, 33554339, 33554340, 33554341, 33554342, 33554343, 33554344, 33554345, 0x1FFFFAA, 33554347, 33554348, 33554349, 33554350, 0x1FFFFAF, 33554352, 0x1FFFFB1, 33554354, 33554355, 33554356, 33554357, 33554358, 33554359, 33554360, 33554361, 33554362, 0x1FFFFBB, 33554364, 33554365, 33554366, 0x1FFFFBF, 33554368, 0x1FFFFC1, 33554370, 33554371, 33554372, 33554373, 33554374, 33554375, 33554376, 33554377, 33554378, 33554379, 0x1FFFFCC, 33554381, 33554382, 0x1FFFFCF, 33554384, 0x1FFFFD1, 33554386, 33554387, 33554388, 33554389, 33554390, 33554391, 33554392, 33554393, 33554394, 33554395};
    private static final byte[] CODE_LENGTHS = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 5, 13, 9, 14, 15, 6, 7, 13, 10, 9, 10, 10, 7, 7, 6, 5, 4, 4, 4, 5, 6, 6, 6, 6, 6, 6, 6, 8, 17, 6, 15, 10, 15, 7, 8, 8, 7, 8, 7, 7, 9, 8, 9, 9, 9, 7, 7, 8, 8, 9, 9, 7, 6, 8, 9, 9, 8, 9, 9, 11, 26, 11, 14, 7, 18, 5, 7, 5, 6, 5, 7, 6, 6, 5, 8, 8, 6, 6, 6, 5, 6, 9, 6, 6, 5, 7, 7, 7, 7, 7, 8, 17, 12, 17, 12, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25};
    private static final Huffman INSTANCE = new Huffman();
    private final Node root = new Node();

    public static Huffman get() {
        return INSTANCE;
    }

    private Huffman() {
        this.buildTree();
    }

    void encode(byte[] data, OutputStream out) throws IOException {
        long current = 0L;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            int b = data[i] & 0xFF;
            int code = CODES[b];
            byte nbits = CODE_LENGTHS[b];
            current <<= nbits;
            current |= (long)code;
            n += nbits;
            while (n >= 8) {
                out.write((int)(current >> (n -= 8)));
            }
        }
        if (n > 0) {
            current <<= 8 - n;
            out.write((int)(current |= (long)(255 >>> n)));
        }
    }

    int encodedLength(byte[] bytes) {
        long len = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            len += (long)CODE_LENGTHS[b];
        }
        return (int)(len + 7L >> 3);
    }

    byte[] decode(byte[] buf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Node node = this.root;
        int current = 0;
        int nbits = 0;
        for (int i = 0; i < buf.length; ++i) {
            int b = buf[i] & 0xFF;
            current = current << 8 | b;
            nbits += 8;
            while (nbits >= 8) {
                int c = current >>> nbits - 8 & 0xFF;
                if ((node = node.children[c]).children == null) {
                    baos.write(node.symbol);
                    nbits -= node.terminalBits;
                    node = this.root;
                    continue;
                }
                nbits -= 8;
            }
        }
        while (nbits > 0) {
            int c = current << 8 - nbits & 0xFF;
            if ((node = node.children[c]).children != null || node.terminalBits > nbits) break;
            baos.write(node.symbol);
            nbits -= node.terminalBits;
            node = this.root;
        }
        return baos.toByteArray();
    }

    private void buildTree() {
        for (int i = 0; i < CODE_LENGTHS.length; ++i) {
            this.addCode(i, CODES[i], CODE_LENGTHS[i]);
        }
    }

    private void addCode(int sym, int code, byte len) {
        Node terminal = new Node(sym, len);
        Node current = this.root;
        while (len > 8) {
            len = (byte)(len - 8);
            int i = code >>> len & 0xFF;
            if (current.children == null) {
                throw new IllegalStateException("invalid dictionary: prefix not unique");
            }
            if (current.children[i] == null) {
                ((Node)current).children[i] = new Node();
            }
            current = current.children[i];
        }
        int shift = 8 - len;
        int start = code << shift & 0xFF;
        int end = 1 << shift;
        for (int i = start; i < start + end; ++i) {
            ((Node)current).children[i] = terminal;
        }
    }

    private static final class Node {
        private final Node[] children;
        private final int symbol;
        private final int terminalBits;

        Node() {
            this.children = new Node[256];
            this.symbol = 0;
            this.terminalBits = 0;
        }

        Node(int symbol, int bits) {
            this.children = null;
            this.symbol = symbol;
            int b = bits & 7;
            this.terminalBits = b == 0 ? 8 : b;
        }
    }
}

