/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Dns;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.InternalCache;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.RouteSelector;
import com.squareup.okhttp.internal.http.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.net.CookieHandler;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class HttpEngine {
    public static final int MAX_REDIRECTS = 20;
    private static final ResponseBody EMPTY_BODY = new ResponseBody(){

        @Override
        public MediaType contentType() {
            return null;
        }

        @Override
        public long contentLength() {
            return 0L;
        }

        @Override
        public BufferedSource source() {
            return new Buffer();
        }
    };
    final OkHttpClient client;
    private Connection connection;
    private RouteSelector routeSelector;
    private Route route;
    private final Response priorResponse;
    private Transport transport;
    long sentRequestMillis = -1L;
    private boolean transparentGzip;
    public final boolean bufferRequestBody;
    private final Request userRequest;
    private Request networkRequest;
    private Response cacheResponse;
    private Response networkResponse;
    private Response userResponse;
    private Sink requestBodyOut;
    private BufferedSink bufferedRequestBody;
    private Source responseTransferSource;
    private BufferedSource responseBody;
    private InputStream responseBodyBytes;
    private CacheRequest storeRequest;
    private CacheStrategy cacheStrategy;

    public HttpEngine(OkHttpClient client, Request request, boolean bufferRequestBody, Connection connection, RouteSelector routeSelector, RetryableSink requestBodyOut, Response priorResponse) {
        this.client = client;
        this.userRequest = request;
        this.bufferRequestBody = bufferRequestBody;
        this.connection = connection;
        this.routeSelector = routeSelector;
        this.requestBodyOut = requestBodyOut;
        this.priorResponse = priorResponse;
        if (connection != null) {
            Internal.instance.setOwner(connection, this);
            this.route = connection.getRoute();
        } else {
            this.route = null;
        }
    }

    public void sendRequest() throws IOException {
        if (this.cacheStrategy != null) {
            return;
        }
        if (this.transport != null) {
            throw new IllegalStateException();
        }
        Request request = this.networkRequest(this.userRequest);
        InternalCache responseCache = Internal.instance.internalCache(this.client);
        Response cacheCandidate = responseCache != null ? responseCache.get(request) : null;
        long now = System.currentTimeMillis();
        this.cacheStrategy = new CacheStrategy.Factory(now, request, cacheCandidate).get();
        this.networkRequest = this.cacheStrategy.networkRequest;
        this.cacheResponse = this.cacheStrategy.cacheResponse;
        if (responseCache != null) {
            responseCache.trackResponse(this.cacheStrategy);
        }
        if (cacheCandidate != null && this.cacheResponse == null) {
            Util.closeQuietly(cacheCandidate.body());
        }
        if (this.networkRequest != null) {
            if (this.connection == null) {
                this.connect(this.networkRequest);
            }
            if (Internal.instance.getOwner(this.connection) != this && !Internal.instance.isSpdy(this.connection)) {
                throw new AssertionError();
            }
            this.transport = Internal.instance.newTransport(this.connection, this);
            if (this.hasRequestBody() && this.requestBodyOut == null) {
                this.requestBodyOut = this.transport.createRequestBody(request);
            }
        } else {
            if (this.connection != null) {
                Internal.instance.recycle(this.client.getConnectionPool(), this.connection);
                this.connection = null;
            }
            this.userResponse = this.cacheResponse != null ? this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).build() : new Response.Builder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(EMPTY_BODY).build();
            if (this.userResponse.body() != null) {
                this.initContentStream(this.userResponse.body().source());
            }
        }
    }

    private static Response stripBody(Response response) {
        return response != null && response.body() != null ? response.newBuilder().body(null).build() : response;
    }

    private void connect(Request request) throws IOException {
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        if (this.routeSelector == null) {
            String uriHost = request.url().getHost();
            if (uriHost == null || uriHost.length() == 0) {
                throw new UnknownHostException(request.url().toString());
            }
            SSLSocketFactory sslSocketFactory = null;
            HostnameVerifier hostnameVerifier = null;
            if (request.isHttps()) {
                sslSocketFactory = this.client.getSslSocketFactory();
                hostnameVerifier = this.client.getHostnameVerifier();
            }
            Address address = new Address(uriHost, Util.getEffectivePort(request.url()), this.client.getSocketFactory(), sslSocketFactory, hostnameVerifier, this.client.getAuthenticator(), this.client.getProxy(), this.client.getProtocols());
            this.routeSelector = new RouteSelector(address, request.uri(), this.client.getProxySelector(), this.client.getConnectionPool(), Dns.DEFAULT, Internal.instance.routeDatabase(this.client));
        }
        this.connection = this.routeSelector.next(request.method());
        Internal.instance.setOwner(this.connection, this);
        if (!Internal.instance.isConnected(this.connection)) {
            Internal.instance.connect(this.connection, this.client.getConnectTimeout(), this.client.getReadTimeout(), this.client.getWriteTimeout(), this.tunnelRequest(this.connection, request));
            if (Internal.instance.isSpdy(this.connection)) {
                Internal.instance.share(this.client.getConnectionPool(), this.connection);
            }
            Internal.instance.routeDatabase(this.client).connected(this.connection.getRoute());
        }
        Internal.instance.setTimeouts(this.connection, this.client.getReadTimeout(), this.client.getWriteTimeout());
        this.route = this.connection.getRoute();
    }

    public void writingRequestHeaders() {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        this.sentRequestMillis = System.currentTimeMillis();
    }

    boolean hasRequestBody() {
        return HttpMethod.hasRequestBody(this.userRequest.method()) && !Util.emptySink().equals(this.requestBodyOut);
    }

    public Sink getRequestBody() {
        if (this.cacheStrategy == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public BufferedSink getBufferedRequestBody() {
        BufferedSink result = this.bufferedRequestBody;
        if (result != null) {
            return result;
        }
        Sink requestBody = this.getRequestBody();
        return requestBody != null ? (this.bufferedRequestBody = Okio.buffer(requestBody)) : null;
    }

    public boolean hasResponse() {
        return this.userResponse != null;
    }

    public Request getRequest() {
        return this.userRequest;
    }

    public Response getResponse() {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        return this.userResponse;
    }

    public BufferedSource getResponseBody() {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        return this.responseBody;
    }

    public InputStream getResponseBodyBytes() {
        InputStream result = this.responseBodyBytes;
        return result != null ? result : (this.responseBodyBytes = Okio.buffer(this.getResponseBody()).inputStream());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HttpEngine recover(IOException e, Sink requestBodyOut) {
        boolean canRetryRequestBody;
        if (this.routeSelector != null && this.connection != null) {
            this.routeSelector.connectFailed(this.connection, e);
        }
        boolean bl = canRetryRequestBody = requestBodyOut == null || requestBodyOut instanceof RetryableSink;
        if (this.routeSelector == null && this.connection == null || this.routeSelector != null && !this.routeSelector.hasNext() || !this.isRecoverable(e) || !canRetryRequestBody) {
            return null;
        }
        Connection connection = this.close();
        return new HttpEngine(this.client, this.userRequest, this.bufferRequestBody, connection, this.routeSelector, (RetryableSink)requestBodyOut, this.priorResponse);
    }

    public HttpEngine recover(IOException e) {
        return this.recover(e, this.requestBodyOut);
    }

    private boolean isRecoverable(IOException e) {
        boolean sslFailure = e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException;
        boolean protocolFailure = e instanceof ProtocolException;
        return !sslFailure && !protocolFailure;
    }

    public Route getRoute() {
        return this.route;
    }

    private void maybeCache() throws IOException {
        InternalCache responseCache = Internal.instance.internalCache(this.client);
        if (responseCache == null) {
            return;
        }
        if (!CacheStrategy.isCacheable(this.userResponse, this.networkRequest)) {
            if (HttpMethod.invalidatesCache(this.networkRequest.method())) {
                try {
                    responseCache.remove(this.networkRequest);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        this.storeRequest = responseCache.put(HttpEngine.stripBody(this.userResponse));
    }

    public void releaseConnection() throws IOException {
        if (this.transport != null && this.connection != null) {
            this.transport.releaseConnectionOnIdle();
        }
        this.connection = null;
    }

    public void disconnect() {
        if (this.transport != null) {
            try {
                this.transport.disconnect(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Connection close() {
        if (this.bufferedRequestBody != null) {
            Util.closeQuietly(this.bufferedRequestBody);
        } else if (this.requestBodyOut != null) {
            Util.closeQuietly(this.requestBodyOut);
        }
        if (this.responseBody == null) {
            if (this.connection != null) {
                Util.closeQuietly(this.connection.getSocket());
            }
            this.connection = null;
            return null;
        }
        Util.closeQuietly(this.responseBody);
        Util.closeQuietly(this.responseBodyBytes);
        if (this.transport != null && this.connection != null && !this.transport.canReuseConnection()) {
            Util.closeQuietly(this.connection.getSocket());
            this.connection = null;
            return null;
        }
        if (this.connection != null && !Internal.instance.clearOwner(this.connection)) {
            this.connection = null;
        }
        Connection result = this.connection;
        this.connection = null;
        return result;
    }

    private void initContentStream(Source transferSource) throws IOException {
        this.responseTransferSource = transferSource;
        if (this.transparentGzip && "gzip".equalsIgnoreCase(this.userResponse.header("Content-Encoding"))) {
            this.userResponse = this.userResponse.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").build();
            this.responseBody = Okio.buffer(new GzipSource(transferSource));
        } else {
            this.responseBody = Okio.buffer(transferSource);
        }
    }

    public boolean hasResponseBody() {
        if (this.userRequest.method().equals("HEAD")) {
            return false;
        }
        int responseCode = this.userResponse.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return OkHeaders.contentLength(this.networkResponse) != -1L || "chunked".equalsIgnoreCase(this.networkResponse.header("Transfer-Encoding"));
    }

    private Request networkRequest(Request request) throws IOException {
        CookieHandler cookieHandler;
        Request.Builder result = request.newBuilder();
        if (request.header("Host") == null) {
            result.header("Host", HttpEngine.hostHeader(request.url()));
        }
        if ((this.connection == null || this.connection.getProtocol() != Protocol.HTTP_1_0) && request.header("Connection") == null) {
            result.header("Connection", "Keep-Alive");
        }
        if (request.header("Accept-Encoding") == null) {
            this.transparentGzip = true;
            result.header("Accept-Encoding", "gzip");
        }
        if ((cookieHandler = this.client.getCookieHandler()) != null) {
            Map<String, List<String>> headers = OkHeaders.toMultimap(result.build().headers(), null);
            Map<String, List<String>> cookies = cookieHandler.get(request.uri(), headers);
            OkHeaders.addCookies(result, cookies);
        }
        return result.build();
    }

    public static String hostHeader(URL url) {
        return Util.getEffectivePort(url) != Util.getDefaultPort(url.getProtocol()) ? url.getHost() + ":" + url.getPort() : url.getHost();
    }

    public void readResponse() throws IOException {
        if (this.userResponse != null) {
            return;
        }
        if (this.networkRequest == null && this.cacheResponse == null) {
            throw new IllegalStateException("call sendRequest() first!");
        }
        if (this.networkRequest == null) {
            return;
        }
        if (this.bufferedRequestBody != null && this.bufferedRequestBody.buffer().size() > 0L) {
            this.bufferedRequestBody.flush();
        }
        if (this.sentRequestMillis == -1L) {
            if (OkHeaders.contentLength(this.networkRequest) == -1L && this.requestBodyOut instanceof RetryableSink) {
                long contentLength = ((RetryableSink)this.requestBodyOut).contentLength();
                this.networkRequest = this.networkRequest.newBuilder().header("Content-Length", Long.toString(contentLength)).build();
            }
            this.transport.writeRequestHeaders(this.networkRequest);
        }
        if (this.requestBodyOut != null) {
            if (this.bufferedRequestBody != null) {
                this.bufferedRequestBody.close();
            } else {
                this.requestBodyOut.close();
            }
            if (this.requestBodyOut instanceof RetryableSink && !Util.emptySink().equals(this.requestBodyOut)) {
                this.transport.writeRequestBody((RetryableSink)this.requestBodyOut);
            }
        }
        this.transport.flushRequest();
        this.networkResponse = this.transport.readResponseHeaders().request(this.networkRequest).handshake(this.connection.getHandshake()).header(OkHeaders.SENT_MILLIS, Long.toString(this.sentRequestMillis)).header(OkHeaders.RECEIVED_MILLIS, Long.toString(System.currentTimeMillis())).build();
        Internal.instance.setProtocol(this.connection, this.networkResponse.protocol());
        this.receiveHeaders(this.networkResponse.headers());
        if (this.cacheResponse != null) {
            if (HttpEngine.validate(this.cacheResponse, this.networkResponse)) {
                this.userResponse = this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).headers(HttpEngine.combine(this.cacheResponse.headers(), this.networkResponse.headers())).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody(this.networkResponse)).build();
                this.transport.emptyTransferStream();
                this.releaseConnection();
                InternalCache responseCache = Internal.instance.internalCache(this.client);
                responseCache.trackConditionalCacheHit();
                responseCache.update(this.cacheResponse, HttpEngine.stripBody(this.userResponse));
                if (this.cacheResponse.body() != null) {
                    this.initContentStream(this.cacheResponse.body().source());
                }
                return;
            }
            Util.closeQuietly(this.cacheResponse.body());
        }
        this.userResponse = this.networkResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody(this.networkResponse)).build();
        if (!this.hasResponseBody()) {
            this.responseTransferSource = this.transport.getTransferStream(this.storeRequest);
            this.responseBody = Okio.buffer(this.responseTransferSource);
            return;
        }
        this.maybeCache();
        this.initContentStream(this.transport.getTransferStream(this.storeRequest));
    }

    private static boolean validate(Response cached, Response network) {
        Date networkLastModified;
        if (network.code() == 304) {
            return true;
        }
        Date lastModified = cached.headers().getDate("Last-Modified");
        return lastModified != null && (networkLastModified = network.headers().getDate("Last-Modified")) != null && networkLastModified.getTime() < lastModified.getTime();
    }

    private static Headers combine(Headers cachedHeaders, Headers networkHeaders) throws IOException {
        String fieldName;
        int i;
        Headers.Builder result = new Headers.Builder();
        for (i = 0; i < cachedHeaders.size(); ++i) {
            fieldName = cachedHeaders.name(i);
            String value = cachedHeaders.value(i);
            if ("Warning".equals(fieldName) && value.startsWith("1") || OkHeaders.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null) continue;
            result.add(fieldName, value);
        }
        for (i = 0; i < networkHeaders.size(); ++i) {
            fieldName = networkHeaders.name(i);
            if (!OkHeaders.isEndToEnd(fieldName)) continue;
            result.add(fieldName, networkHeaders.value(i));
        }
        return result.build();
    }

    private Request tunnelRequest(Connection connection, Request request) throws IOException {
        String proxyAuthorization;
        if (!connection.getRoute().requiresTunnel()) {
            return null;
        }
        String host = request.url().getHost();
        int port = Util.getEffectivePort(request.url());
        String authority = port == Util.getDefaultPort("https") ? host : host + ":" + port;
        Request.Builder result = new Request.Builder().url(new URL("https", host, port, "/")).header("Host", authority).header("Proxy-Connection", "Keep-Alive");
        String userAgent = request.header("User-Agent");
        if (userAgent != null) {
            result.header("User-Agent", userAgent);
        }
        if ((proxyAuthorization = request.header("Proxy-Authorization")) != null) {
            result.header("Proxy-Authorization", proxyAuthorization);
        }
        return result.build();
    }

    public void receiveHeaders(Headers headers) throws IOException {
        CookieHandler cookieHandler = this.client.getCookieHandler();
        if (cookieHandler != null) {
            cookieHandler.put(this.userRequest.uri(), OkHeaders.toMultimap(headers, null));
        }
    }

    public Request followUpRequest() throws IOException {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        Proxy selectedProxy = this.getRoute() != null ? this.getRoute().getProxy() : this.client.getProxy();
        int responseCode = this.userResponse.code();
        switch (responseCode) {
            case 407: {
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                return OkHeaders.processAuthHeader(this.client.getAuthenticator(), this.userResponse, selectedProxy);
            }
            case 307: {
                if (!this.userRequest.method().equals("GET") && !this.userRequest.method().equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                String location = this.userResponse.header("Location");
                if (location == null) {
                    return null;
                }
                URL url = new URL(this.userRequest.url(), location);
                if (!url.getProtocol().equals("https") && !url.getProtocol().equals("http")) {
                    return null;
                }
                boolean sameProtocol = url.getProtocol().equals(this.userRequest.url().getProtocol());
                if (!sameProtocol && !this.client.getFollowSslRedirects()) {
                    return null;
                }
                Request.Builder requestBuilder = this.userRequest.newBuilder();
                if (HttpMethod.hasRequestBody(this.userRequest.method())) {
                    requestBuilder.method("GET", null);
                    requestBuilder.removeHeader("Transfer-Encoding");
                    requestBuilder.removeHeader("Content-Length");
                    requestBuilder.removeHeader("Content-Type");
                }
                if (!this.sameConnection(url)) {
                    requestBuilder.removeHeader("Authorization");
                }
                return requestBuilder.url(url).build();
            }
        }
        return null;
    }

    public boolean sameConnection(URL followUp) {
        URL url = this.userRequest.url();
        return url.getHost().equals(followUp.getHost()) && Util.getEffectivePort(url) == Util.getEffectivePort(followUp) && url.getProtocol().equals(followUp.getProtocol());
    }
}

