/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import okio.BufferedSource;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() throws IOException {
        byte[] bytes;
        long contentLength = this.contentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        BufferedSource source = this.source();
        try {
            bytes = source.readByteArray();
        }
        finally {
            Util.closeQuietly(source);
        }
        if (contentLength != -1L && contentLength != (long)bytes.length) {
            throw new IOException("Content-Length and stream length disagree");
        }
        return bytes;
    }

    public final Reader charStream() {
        Reader r = this.reader;
        return r != null ? r : (this.reader = new InputStreamReader(this.byteStream(), this.charset()));
    }

    public final String string() throws IOException {
        return new String(this.bytes(), this.charset().name());
    }

    private Charset charset() {
        MediaType contentType = this.contentType();
        return contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8;
    }

    @Override
    public void close() throws IOException {
        this.source().close();
    }
}

