/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.TermStatistics;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.search.EmptyScorer;
import org.elasticsearch.search.lookup.CachedPositionIterator;
import org.elasticsearch.search.lookup.IndexLookup;
import org.elasticsearch.search.lookup.PositionIterator;
import org.elasticsearch.search.lookup.TermPosition;

public class IndexFieldTerm
implements Iterable<TermPosition> {
    DocsEnum docsEnum;
    private final int flags;
    private final String fieldName;
    private final String term;
    private final PositionIterator iterator;
    private final Term identifier;
    private final TermStatistics termStats;
    private static EmptyScorer EMPTY_DOCS_ENUM = new EmptyScorer(null);
    private int freq = 0;

    public long df() throws IOException {
        return this.termStats.docFreq();
    }

    public long ttf() throws IOException {
        return this.termStats.totalTermFreq();
    }

    void setNextReader(AtomicReader reader) {
        try {
            int luceneFrequencyFlag = this.getLuceneFrequencyFlag(this.flags);
            if (this.shouldRetrieveFrequenciesOnly()) {
                this.docsEnum = this.getOnlyDocsEnum(luceneFrequencyFlag, reader);
            } else {
                int lucenePositionsFlags = this.getLucenePositionsFlags(this.flags);
                this.docsEnum = this.getDocsAndPosEnum(lucenePositionsFlags, reader);
                if (this.docsEnum == null) {
                    this.docsEnum = this.getOnlyDocsEnum(luceneFrequencyFlag, reader);
                }
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to get posting list for field " + this.fieldName + " and term " + this.term, e);
        }
    }

    private boolean shouldRetrieveFrequenciesOnly() {
        return (this.flags & 0xFFFFFFF7) == 0;
    }

    private int getLuceneFrequencyFlag(int flags) {
        return (flags & 8) > 0 ? 1 : 0;
    }

    private int getLucenePositionsFlags(int flags) {
        int lucenePositionsFlags = (flags & 4) > 0 ? 2 : 0;
        return lucenePositionsFlags |= (flags & 2) > 0 ? 1 : 0;
    }

    private DocsEnum getDocsAndPosEnum(int luceneFlags, AtomicReader reader) throws IOException {
        TermsEnum termsEnum;
        Terms terms;
        assert (this.identifier.field() != null);
        assert (this.identifier.bytes() != null);
        Fields fields = reader.fields();
        DocsAndPositionsEnum newDocsEnum = null;
        if (fields != null && (terms = fields.terms(this.identifier.field())) != null && terms.hasPositions() && (termsEnum = terms.iterator(null)).seekExact(this.identifier.bytes())) {
            newDocsEnum = termsEnum.docsAndPositions(reader.getLiveDocs(), this.docsEnum instanceof DocsAndPositionsEnum ? (DocsAndPositionsEnum)this.docsEnum : null, luceneFlags);
        }
        return newDocsEnum;
    }

    private DocsEnum getOnlyDocsEnum(int luceneFlags, AtomicReader reader) throws IOException {
        TermsEnum termsEnum;
        Terms terms;
        assert (this.identifier.field() != null);
        assert (this.identifier.bytes() != null);
        Fields fields = reader.fields();
        DocsEnum newDocsEnum = null;
        if (fields != null && (terms = fields.terms(this.identifier.field())) != null && (termsEnum = terms.iterator(null)).seekExact(this.identifier.bytes())) {
            newDocsEnum = termsEnum.docs(reader.getLiveDocs(), this.docsEnum, luceneFlags);
        }
        if (newDocsEnum == null) {
            newDocsEnum = EMPTY_DOCS_ENUM;
        }
        return newDocsEnum;
    }

    public void setNextDoc(int docId) {
        assert (this.docsEnum != null);
        try {
            int currentDocPos = this.docsEnum.docID();
            if (currentDocPos < docId) {
                currentDocPos = this.docsEnum.advance(docId);
            }
            this.freq = currentDocPos == docId ? this.docsEnum.freq() : 0;
            this.iterator.nextDoc();
        }
        catch (IOException e) {
            throw new ElasticsearchException("While trying to initialize term positions in IndexFieldTerm.setNextDoc() ", e);
        }
    }

    public IndexFieldTerm(String term, String fieldName, IndexLookup indexLookup, int flags) {
        boolean doRecord;
        assert (fieldName != null);
        this.fieldName = fieldName;
        assert (term != null);
        this.term = term;
        assert (indexLookup != null);
        this.identifier = new Term(fieldName, term);
        this.flags = flags;
        boolean bl = doRecord = (flags & 0x20) > 0;
        this.iterator = this.withPositions() ? (!doRecord ? new PositionIterator(this) : new CachedPositionIterator(this)) : new PositionIterator(this);
        this.setNextReader(indexLookup.getReader());
        this.setNextDoc(indexLookup.getDocId());
        try {
            this.termStats = indexLookup.getIndexSearcher().termStatistics(this.identifier, TermContext.build(indexLookup.getReaderContext(), this.identifier));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Cannot get term statistics: ", e);
        }
    }

    private boolean withPositions() {
        return this.shouldRetrievePositions() || this.shouldRetrieveOffsets() || this.shouldRetrievePayloads();
    }

    protected boolean shouldRetrievePositions() {
        return (this.flags & 0x10) > 0;
    }

    protected boolean shouldRetrieveOffsets() {
        return (this.flags & 2) > 0;
    }

    protected boolean shouldRetrievePayloads() {
        return (this.flags & 4) > 0;
    }

    public int tf() throws IOException {
        return this.freq;
    }

    @Override
    public Iterator<TermPosition> iterator() {
        return this.iterator.reset();
    }

    public void validateFlags(int flags2) {
        if ((this.flags & flags2) < flags2) {
            throw new ElasticsearchException("You must call get with all required flags! Instead of " + this.getCalledStatement(flags2) + "call " + this.getCallStatement(flags2 | this.flags) + " once");
        }
    }

    private String getCalledStatement(int flags2) {
        String calledFlagsCall1 = this.getFlagsString(this.flags);
        String calledFlagsCall2 = this.getFlagsString(flags2);
        String callStatement1 = this.getCallStatement(calledFlagsCall1);
        String callStatement2 = this.getCallStatement(calledFlagsCall2);
        return " " + callStatement1 + " and " + callStatement2 + " ";
    }

    private String getCallStatement(String calledFlags) {
        return "_index['" + this.fieldName + "'].get('" + this.term + "', " + calledFlags + ")";
    }

    private String getFlagsString(int flags2) {
        String flagsString = null;
        if ((flags2 & 8) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_FREQUENCIES");
        }
        if ((flags2 & 0x10) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_POSITIONS");
        }
        if ((flags2 & 2) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_OFFSETS");
        }
        if ((flags2 & 4) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_PAYLOADS");
        }
        if ((flags2 & 0x20) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_CACHE");
        }
        return flagsString;
    }

    private String anddToFlagsString(String flagsString, String flag) {
        flagsString = flagsString != null ? flagsString + " | " : "";
        flagsString = flagsString + flag;
        return flagsString;
    }

    private String getCallStatement(int flags2) {
        String calledFlags = this.getFlagsString(flags2);
        String callStatement = this.getCallStatement(calledFlags);
        return " " + callStatement + " ";
    }
}

