/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.Counter;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.TopReaderContextAware;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.FilterDoubleValues;
import org.elasticsearch.index.fielddata.FilterLongValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.values.ScriptBytesValues;
import org.elasticsearch.search.aggregations.support.values.ScriptDoubleValues;
import org.elasticsearch.search.aggregations.support.values.ScriptLongValues;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ValuesSource {
    public abstract BytesValues bytesValues();

    public void setNeedsHashes(boolean needsHashes) {
    }

    public void setNeedsGlobalOrdinals(boolean needsGlobalOrdinals) {
    }

    public abstract MetaData metaData();

    public static class GeoPoint
    extends ValuesSource
    implements ReaderContextAware {
        protected boolean needsHashes;
        protected final IndexGeoPointFieldData<?> indexFieldData;
        private final MetaData metaData;
        protected AtomicGeoPointFieldData<?> atomicFieldData;
        private BytesValues bytesValues;
        private GeoPointValues geoPointValues;

        public GeoPoint(IndexGeoPointFieldData<?> indexFieldData, MetaData metaData) {
            this.indexFieldData = indexFieldData;
            this.metaData = metaData;
            this.needsHashes = false;
        }

        @Override
        public MetaData metaData() {
            return this.metaData;
        }

        @Override
        public final void setNeedsHashes(boolean needsHashes) {
            this.needsHashes = needsHashes;
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            this.atomicFieldData = this.indexFieldData.load(reader);
            if (this.bytesValues != null) {
                this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
            }
            if (this.geoPointValues != null) {
                this.geoPointValues = this.atomicFieldData.getGeoPointValues();
            }
        }

        @Override
        public BytesValues bytesValues() {
            if (this.bytesValues == null) {
                this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
            }
            return this.bytesValues;
        }

        public GeoPointValues geoPointValues() {
            if (this.geoPointValues == null) {
                this.geoPointValues = this.atomicFieldData.getGeoPointValues();
            }
            return this.geoPointValues;
        }
    }

    public static class WithScript
    extends Bytes {
        private final BytesValues bytesValues;

        public WithScript(ValuesSource delegate, SearchScript script) {
            this.bytesValues = new BytesValues(delegate, script);
        }

        @Override
        public MetaData metaData() {
            return MetaData.UNKNOWN;
        }

        @Override
        public BytesValues bytesValues() {
            return this.bytesValues;
        }

        static class BytesValues
        extends org.elasticsearch.index.fielddata.BytesValues {
            private final ValuesSource source;
            private final SearchScript script;

            public BytesValues(ValuesSource source, SearchScript script) {
                super(true);
                this.source = source;
                this.script = script;
            }

            @Override
            public int setDocument(int docId) {
                return this.source.bytesValues().setDocument(docId);
            }

            @Override
            public BytesRef nextValue() {
                BytesRef value = this.source.bytesValues().nextValue();
                this.script.setNextVar("_value", value.utf8ToString());
                this.scratch.copyChars(this.script.run().toString());
                return this.scratch;
            }
        }
    }

    public static abstract class Numeric
    extends ValuesSource {
        public abstract boolean isFloatingPoint();

        public abstract LongValues longValues();

        public abstract DoubleValues doubleValues();

        public static class SortedAndUnique
        extends Numeric
        implements ReaderContextAware {
            private final Numeric delegate;
            private final MetaData metaData;
            private LongValues longValues;
            private DoubleValues doubleValues;
            private BytesValues bytesValues;

            public SortedAndUnique(Numeric delegate) {
                this.delegate = delegate;
                this.metaData = MetaData.builder(delegate.metaData()).uniqueness(MetaData.Uniqueness.UNIQUE).build();
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.delegate.isFloatingPoint();
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.longValues = null;
                this.doubleValues = null;
                this.bytesValues = null;
            }

            @Override
            public LongValues longValues() {
                if (this.longValues == null) {
                    this.longValues = this.delegate.longValues();
                    if (this.longValues.isMultiValued() && (!this.delegate.metaData().uniqueness.unique() || this.longValues.getOrder() != AtomicFieldData.Order.NUMERIC)) {
                        this.longValues = new SortedUniqueLongValues(this.longValues);
                    }
                }
                return this.longValues;
            }

            @Override
            public DoubleValues doubleValues() {
                if (this.doubleValues == null) {
                    this.doubleValues = this.delegate.doubleValues();
                    if (this.doubleValues.isMultiValued() && (!this.delegate.metaData().uniqueness.unique() || this.doubleValues.getOrder() != AtomicFieldData.Order.NUMERIC)) {
                        this.doubleValues = new SortedUniqueDoubleValues(this.doubleValues);
                    }
                }
                return this.doubleValues;
            }

            @Override
            public BytesValues bytesValues() {
                if (this.bytesValues == null) {
                    this.bytesValues = this.delegate.bytesValues();
                    if (this.bytesValues.isMultiValued() && (!this.delegate.metaData().uniqueness.unique() || this.bytesValues.getOrder() != AtomicFieldData.Order.BYTES)) {
                        this.bytesValues = new Bytes.SortedAndUnique.SortedUniqueBytesValues(this.bytesValues);
                    }
                }
                return this.bytesValues;
            }

            private static class SortedUniqueDoubleValues
            extends FilterDoubleValues {
                private int numUniqueValues;
                private double[] array = new double[2];
                private int pos = Integer.MAX_VALUE;

                SortedUniqueDoubleValues(DoubleValues delegate) {
                    super(delegate);
                }

                @Override
                public int setDocument(int docId) {
                    int numValues = super.setDocument(docId);
                    this.array = ArrayUtil.grow(this.array, numValues);
                    for (int i = 0; i < numValues; ++i) {
                        this.array[i] = super.nextValue();
                    }
                    this.pos = 0;
                    this.numUniqueValues = CollectionUtils.sortAndDedup(this.array, numValues);
                    return this.numUniqueValues;
                }

                @Override
                public double nextValue() {
                    assert (this.pos < this.numUniqueValues);
                    return this.array[this.pos++];
                }

                @Override
                public AtomicFieldData.Order getOrder() {
                    return AtomicFieldData.Order.NUMERIC;
                }
            }

            private static class SortedUniqueLongValues
            extends FilterLongValues {
                int numUniqueValues;
                long[] array = new long[2];
                int pos = Integer.MAX_VALUE;

                protected SortedUniqueLongValues(LongValues delegate) {
                    super(delegate);
                }

                @Override
                public int setDocument(int docId) {
                    int numValues = super.setDocument(docId);
                    this.array = ArrayUtil.grow(this.array, numValues);
                    for (int i = 0; i < numValues; ++i) {
                        this.array[i] = super.nextValue();
                    }
                    this.pos = 0;
                    this.numUniqueValues = CollectionUtils.sortAndDedup(this.array, numValues);
                    return this.numUniqueValues;
                }

                @Override
                public long nextValue() {
                    assert (this.pos < this.numUniqueValues);
                    return this.array[this.pos++];
                }

                @Override
                public AtomicFieldData.Order getOrder() {
                    return AtomicFieldData.Order.NUMERIC;
                }
            }
        }

        public static class Script
        extends Numeric {
            private final ValueType scriptValueType;
            private final ScriptDoubleValues doubleValues;
            private final ScriptLongValues longValues;
            private final ScriptBytesValues bytesValues;

            public Script(SearchScript script, ValueType scriptValueType) {
                this.scriptValueType = scriptValueType;
                this.longValues = new ScriptLongValues(script);
                this.doubleValues = new ScriptDoubleValues(script);
                this.bytesValues = new ScriptBytesValues(script);
            }

            @Override
            public MetaData metaData() {
                return MetaData.UNKNOWN;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.scriptValueType != null ? this.scriptValueType.isFloatingPoint() : true;
            }

            @Override
            public LongValues longValues() {
                return this.longValues;
            }

            @Override
            public DoubleValues doubleValues() {
                return this.doubleValues;
            }

            @Override
            public BytesValues bytesValues() {
                return this.bytesValues;
            }
        }

        public static class FieldData
        extends Numeric
        implements ReaderContextAware {
            protected boolean needsHashes;
            protected final IndexNumericFieldData<?> indexFieldData;
            protected final MetaData metaData;
            protected AtomicNumericFieldData atomicFieldData;
            private BytesValues bytesValues;
            private LongValues longValues;
            private DoubleValues doubleValues;

            public FieldData(IndexNumericFieldData<?> indexFieldData, MetaData metaData) {
                this.indexFieldData = indexFieldData;
                this.metaData = metaData;
                this.needsHashes = false;
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.indexFieldData.getNumericType().isFloatingPoint();
            }

            @Override
            public final void setNeedsHashes(boolean needsHashes) {
                this.needsHashes = needsHashes;
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.atomicFieldData = this.indexFieldData.load(reader);
                if (this.bytesValues != null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
                }
                if (this.longValues != null) {
                    this.longValues = this.atomicFieldData.getLongValues();
                }
                if (this.doubleValues != null) {
                    this.doubleValues = this.atomicFieldData.getDoubleValues();
                }
            }

            @Override
            public BytesValues bytesValues() {
                if (this.bytesValues == null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
                }
                return this.bytesValues;
            }

            @Override
            public LongValues longValues() {
                if (this.longValues == null) {
                    this.longValues = this.atomicFieldData.getLongValues();
                }
                assert (this.longValues.getOrder() == AtomicFieldData.Order.NUMERIC);
                return this.longValues;
            }

            @Override
            public DoubleValues doubleValues() {
                if (this.doubleValues == null) {
                    this.doubleValues = this.atomicFieldData.getDoubleValues();
                }
                assert (this.doubleValues.getOrder() == AtomicFieldData.Order.NUMERIC);
                return this.doubleValues;
            }
        }

        public static class WithScript
        extends Numeric {
            private final LongValues longValues;
            private final DoubleValues doubleValues;
            private final WithScript.BytesValues bytesValues;

            public WithScript(Numeric delegate, SearchScript script) {
                this.longValues = new LongValues(delegate, script);
                this.doubleValues = new DoubleValues(delegate, script);
                this.bytesValues = new WithScript.BytesValues(delegate, script);
            }

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public BytesValues bytesValues() {
                return this.bytesValues;
            }

            @Override
            public LongValues longValues() {
                return this.longValues;
            }

            @Override
            public DoubleValues doubleValues() {
                return this.doubleValues;
            }

            @Override
            public MetaData metaData() {
                return MetaData.UNKNOWN;
            }

            static class DoubleValues
            extends org.elasticsearch.index.fielddata.DoubleValues {
                private final Numeric source;
                private final SearchScript script;

                public DoubleValues(Numeric source, SearchScript script) {
                    super(true);
                    this.source = source;
                    this.script = script;
                }

                @Override
                public int setDocument(int docId) {
                    return this.source.doubleValues().setDocument(docId);
                }

                @Override
                public double nextValue() {
                    this.script.setNextVar("_value", this.source.doubleValues().nextValue());
                    return this.script.runAsDouble();
                }
            }

            static class LongValues
            extends org.elasticsearch.index.fielddata.LongValues {
                private final Numeric source;
                private final SearchScript script;

                public LongValues(Numeric source, SearchScript script) {
                    super(true);
                    this.source = source;
                    this.script = script;
                }

                @Override
                public int setDocument(int docId) {
                    return this.source.longValues().setDocument(docId);
                }

                @Override
                public long nextValue() {
                    this.script.setNextVar("_value", this.source.longValues().nextValue());
                    return this.script.runAsLong();
                }
            }
        }
    }

    public static abstract class Bytes
    extends ValuesSource {

        public static class SortedAndUnique
        extends Bytes
        implements ReaderContextAware {
            private final ValuesSource delegate;
            private final MetaData metaData;
            private BytesValues bytesValues;

            public SortedAndUnique(ValuesSource delegate) {
                this.delegate = delegate;
                this.metaData = MetaData.builder(delegate.metaData()).uniqueness(MetaData.Uniqueness.UNIQUE).build();
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.bytesValues = null;
            }

            @Override
            public BytesValues bytesValues() {
                if (this.bytesValues == null) {
                    this.bytesValues = this.delegate.bytesValues();
                    if (this.bytesValues.isMultiValued() && (!this.delegate.metaData().uniqueness.unique() || this.bytesValues.getOrder() != AtomicFieldData.Order.BYTES)) {
                        this.bytesValues = new SortedUniqueBytesValues(this.bytesValues);
                    }
                }
                return this.bytesValues;
            }

            static class SortedUniqueBytesValues
            extends BytesValues {
                final BytesValues delegate;
                int[] indices = new int[1];
                final BytesRefArray bytes;
                int numUniqueValues;
                int pos = Integer.MAX_VALUE;

                public SortedUniqueBytesValues(BytesValues delegate) {
                    super(delegate.isMultiValued());
                    this.delegate = delegate;
                    this.bytes = new BytesRefArray(Counter.newCounter(false));
                }

                @Override
                public int setDocument(int docId) {
                    int numValues = this.delegate.setDocument(docId);
                    this.numUniqueValues = 0;
                    this.pos = 0;
                    if (numValues > 0) {
                        this.bytes.clear();
                        this.indices = ArrayUtil.grow(this.indices, numValues);
                        for (int i = 0; i < numValues; ++i) {
                            BytesRef next = this.delegate.nextValue();
                            this.indices[i] = i;
                            this.bytes.append(next);
                        }
                        this.numUniqueValues = CollectionUtils.sortAndDedup(this.bytes, this.indices);
                    }
                    return this.numUniqueValues;
                }

                @Override
                public BytesRef nextValue() {
                    this.bytes.get(this.scratch, this.indices[this.pos++]);
                    return this.scratch;
                }

                @Override
                public AtomicFieldData.Order getOrder() {
                    return AtomicFieldData.Order.BYTES;
                }
            }
        }

        public static class Script
        extends Bytes {
            private final ScriptBytesValues values;

            public Script(SearchScript script) {
                this.values = new ScriptBytesValues(script);
            }

            @Override
            public MetaData metaData() {
                return MetaData.UNKNOWN;
            }

            @Override
            public BytesValues bytesValues() {
                return this.values;
            }
        }

        public static class FieldData
        extends Bytes
        implements ReaderContextAware {
            protected boolean needsHashes;
            protected final IndexFieldData<?> indexFieldData;
            protected final MetaData metaData;
            protected AtomicFieldData<?> atomicFieldData;
            private BytesValues bytesValues;

            public FieldData(IndexFieldData<?> indexFieldData, MetaData metaData) {
                this.indexFieldData = indexFieldData;
                this.metaData = metaData;
                this.needsHashes = false;
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }

            @Override
            public final void setNeedsHashes(boolean needsHashes) {
                this.needsHashes = needsHashes;
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.atomicFieldData = this.indexFieldData.load(reader);
                if (this.bytesValues != null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
                }
            }

            @Override
            public BytesValues bytesValues() {
                if (this.bytesValues == null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
                }
                return this.bytesValues;
            }
        }

        public static abstract class WithOrdinals
        extends Bytes
        implements TopReaderContextAware {
            @Override
            public abstract BytesValues.WithOrdinals bytesValues();

            @Override
            public abstract void setNextReader(IndexReaderContext var1);

            public abstract BytesValues.WithOrdinals globalBytesValues();

            public abstract long globalMaxOrd(IndexSearcher var1);

            public abstract TermsEnum getGlobalTermsEnum();

            public static class FieldData
            extends WithOrdinals
            implements ReaderContextAware {
                protected boolean needsHashes;
                protected final IndexFieldData.WithOrdinals<?> indexFieldData;
                protected final MetaData metaData;
                private boolean needsGlobalOrdinals;
                protected AtomicFieldData.WithOrdinals<?> atomicFieldData;
                private BytesValues.WithOrdinals bytesValues;
                protected IndexFieldData.WithOrdinals<?> globalFieldData;
                protected AtomicFieldData.WithOrdinals<?> globalAtomicFieldData;
                private BytesValues.WithOrdinals globalBytesValues;
                private long maxOrd = -1L;

                public FieldData(IndexFieldData.WithOrdinals<?> indexFieldData, MetaData metaData) {
                    this.indexFieldData = indexFieldData;
                    this.metaData = metaData;
                    this.needsHashes = false;
                }

                @Override
                public MetaData metaData() {
                    return this.metaData;
                }

                @Override
                public final void setNeedsHashes(boolean needsHashes) {
                    this.needsHashes = needsHashes;
                }

                @Override
                public void setNeedsGlobalOrdinals(boolean needsGlobalOrdinals) {
                    this.needsGlobalOrdinals = needsGlobalOrdinals;
                }

                @Override
                public void setNextReader(AtomicReaderContext reader) {
                    this.atomicFieldData = this.indexFieldData.load(reader);
                    if (this.bytesValues != null) {
                        this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
                    }
                    if (this.globalFieldData != null) {
                        this.globalAtomicFieldData = this.globalFieldData.load(reader);
                        if (this.globalBytesValues != null) {
                            this.globalBytesValues = this.globalAtomicFieldData.getBytesValues(this.needsHashes);
                        }
                    }
                }

                @Override
                public BytesValues.WithOrdinals bytesValues() {
                    if (this.bytesValues == null) {
                        this.bytesValues = this.atomicFieldData.getBytesValues(this.needsHashes);
                    }
                    return this.bytesValues;
                }

                @Override
                public void setNextReader(IndexReaderContext reader) {
                    if (this.needsGlobalOrdinals) {
                        this.globalFieldData = this.indexFieldData.loadGlobal(reader.reader());
                    }
                }

                @Override
                public BytesValues.WithOrdinals globalBytesValues() {
                    if (this.globalBytesValues == null) {
                        this.globalBytesValues = this.globalAtomicFieldData.getBytesValues(this.needsHashes);
                    }
                    return this.globalBytesValues;
                }

                @Override
                public long globalMaxOrd(IndexSearcher indexSearcher) {
                    if (this.maxOrd != -1L) {
                        return this.maxOrd;
                    }
                    IndexReader indexReader = indexSearcher.getIndexReader();
                    if (indexReader.leaves().isEmpty()) {
                        this.maxOrd = 0L;
                        return 0L;
                    }
                    AtomicReaderContext atomicReaderContext = indexReader.leaves().get(0);
                    IndexFieldData.WithOrdinals globalFieldData = this.indexFieldData.loadGlobal(indexReader);
                    Object afd = globalFieldData.load(atomicReaderContext);
                    BytesValues.WithOrdinals values = afd.getBytesValues(false);
                    Ordinals.Docs ordinals = values.ordinals();
                    this.maxOrd = ordinals.getMaxOrd();
                    return this.maxOrd;
                }

                @Override
                public TermsEnum getGlobalTermsEnum() {
                    return this.globalAtomicFieldData.getTermsEnum();
                }
            }
        }
    }

    public static class MetaData {
        public static final MetaData UNKNOWN = new MetaData();
        private long maxAtomicUniqueValuesCount = -1L;
        private boolean multiValued = true;
        private Uniqueness uniqueness = Uniqueness.UNKNOWN;

        private MetaData() {
        }

        private MetaData(MetaData other) {
            this.maxAtomicUniqueValuesCount = other.maxAtomicUniqueValuesCount;
            this.multiValued = other.multiValued;
            this.uniqueness = other.uniqueness;
        }

        private MetaData(long maxAtomicUniqueValuesCount, boolean multiValued, Uniqueness uniqueness) {
            this.maxAtomicUniqueValuesCount = maxAtomicUniqueValuesCount;
            this.multiValued = multiValued;
            this.uniqueness = uniqueness;
        }

        public long maxAtomicUniqueValuesCount() {
            return this.maxAtomicUniqueValuesCount;
        }

        public boolean multiValued() {
            return this.multiValued;
        }

        public Uniqueness uniqueness() {
            return this.uniqueness;
        }

        public static MetaData load(IndexFieldData indexFieldData, SearchContext context) {
            MetaData metaData = new MetaData();
            metaData.uniqueness = Uniqueness.UNIQUE;
            for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
                Object fieldData = indexFieldData.load(readerContext);
                metaData.multiValued |= fieldData.isMultiValued();
                metaData.maxAtomicUniqueValuesCount = Math.max(metaData.maxAtomicUniqueValuesCount, fieldData.getNumberUniqueValues());
            }
            return metaData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(MetaData other) {
            return new Builder(other);
        }

        public static class Builder {
            private final MetaData metaData;

            private Builder() {
                this.metaData = new MetaData();
            }

            private Builder(MetaData metaData) {
                this.metaData = new MetaData(metaData);
            }

            public Builder maxAtomicUniqueValuesCount(long maxAtomicUniqueValuesCount) {
                this.metaData.maxAtomicUniqueValuesCount = maxAtomicUniqueValuesCount;
                return this;
            }

            public Builder multiValued(boolean multiValued) {
                this.metaData.multiValued = multiValued;
                return this;
            }

            public Builder uniqueness(Uniqueness uniqueness) {
                this.metaData.uniqueness = uniqueness;
                return this;
            }

            public MetaData build() {
                return this.metaData;
            }
        }

        public static enum Uniqueness {
            UNIQUE,
            NOT_UNIQUE,
            UNKNOWN;


            public boolean unique() {
                return this == UNIQUE;
            }
        }
    }
}

