/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GeoHashGridAggregator
extends BucketsAggregator {
    private static final int INITIAL_CAPACITY = 50;
    private final int requiredSize;
    private final int shardSize;
    private final ValuesSource.Numeric valuesSource;
    private final LongHash bucketOrds;
    private LongValues values;

    public GeoHashGridAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, int requiredSize, int shardSize, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, 50L, aggregationContext, parent);
        this.valuesSource = valuesSource;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.bucketOrds = new LongHash(50L, aggregationContext.bigArrays());
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.longValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int valuesCount = this.values.setDocument(doc);
        for (int i = 0; i < valuesCount; ++i) {
            long val = this.values.nextValue();
            long bucketOrdinal = this.bucketOrds.add(val);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(doc, bucketOrdinal);
                continue;
            }
            this.collectBucket(doc, bucketOrdinal);
        }
    }

    @Override
    public InternalGeoHashGrid buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        InternalGeoHashGrid.BucketPriorityQueue ordered = new InternalGeoHashGrid.BucketPriorityQueue(size);
        OrdinalBucket spare = null;
        long i = 0L;
        while (i < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new OrdinalBucket();
            }
            spare.geohashAsLong = this.bucketOrds.get(i);
            spare.docCount = this.bucketDocCount(i);
            spare.bucketOrd = i++;
            spare = ordered.insertWithOverflow(spare);
        }
        InternalGeoHashGrid.Bucket[] list = new InternalGeoHashGrid.Bucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            OrdinalBucket bucket = (OrdinalBucket)ordered.pop();
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return new InternalGeoHashGrid(this.name, this.requiredSize, Arrays.asList(list));
    }

    @Override
    public InternalGeoHashGrid buildEmptyAggregation() {
        return new InternalGeoHashGrid(this.name, this.requiredSize, Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }

    static class OrdinalBucket
    extends InternalGeoHashGrid.Bucket {
        long bucketOrd;

        public OrdinalBucket() {
            super(0L, 0L, null);
        }
    }
}

