/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.RamUsage;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;

public class IndicesFieldDataCache
extends AbstractComponent
implements RemovalListener<Key, RamUsage> {
    private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;
    private final Cache<Key, RamUsage> cache;

    @Inject
    public IndicesFieldDataCache(Settings settings, IndicesFieldDataCacheListener indicesFieldDataCacheListener) {
        super(settings);
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
        String size = this.componentSettings.get("size", "-1");
        long sizeInBytes = this.componentSettings.getAsMemory("size", "-1").bytes();
        if (sizeInBytes > ByteSizeValue.MAX_GUAVA_CACHE_SIZE.bytes()) {
            this.logger.warn("reducing requested field data cache size of [{}] to the maximum allowed size of [{}]", new ByteSizeValue(sizeInBytes), ByteSizeValue.MAX_GUAVA_CACHE_SIZE);
            sizeInBytes = ByteSizeValue.MAX_GUAVA_CACHE_SIZE.bytes();
            size = ByteSizeValue.MAX_GUAVA_CACHE_SIZE.toString();
        }
        TimeValue expire = this.componentSettings.getAsTime("expire", null);
        CacheBuilder<Key, RamUsage> cacheBuilder = CacheBuilder.newBuilder().removalListener(this);
        if (sizeInBytes > 0L) {
            cacheBuilder.maximumWeight(sizeInBytes).weigher(new FieldDataWeigher());
        }
        cacheBuilder.concurrencyLevel(16);
        if (expire != null && expire.millis() > 0L) {
            cacheBuilder.expireAfterAccess(expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.logger.debug("using size [{}] [{}], expire [{}]", size, new ByteSizeValue(sizeInBytes), expire);
        this.cache = cacheBuilder.build();
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public IndexFieldDataCache buildIndexFieldDataCache(IndexService indexService, Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
        return new IndexFieldCache(this.logger, this.cache, this.indicesFieldDataCacheListener, indexService, index, fieldNames, fieldDataType);
    }

    public Cache<Key, RamUsage> getCache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<Key, RamUsage> notification) {
        Key key = notification.getKey();
        assert (key != null && key.listeners != null);
        IndexFieldCache indexCache = key.indexCache;
        long sizeInBytes = key.sizeInBytes;
        RamUsage value = notification.getValue();
        assert (sizeInBytes >= 0L || value != null) : "Expected size [" + sizeInBytes + "] to be positive or value [" + value + "] to be non-null";
        if (sizeInBytes == -1L && value != null) {
            sizeInBytes = value.getMemorySizeInBytes();
        }
        for (IndexFieldDataCache.Listener listener : key.listeners) {
            try {
                listener.onUnload(indexCache.fieldNames, indexCache.fieldDataType, notification.wasEvicted(), sizeInBytes);
            }
            catch (Throwable e) {
                this.logger.error("Failed to call listener on field data cache unloading", e, new Object[0]);
            }
        }
    }

    public static class Key {
        public final IndexFieldCache indexCache;
        public final Object readerKey;
        public final List<IndexFieldDataCache.Listener> listeners = new ArrayList<IndexFieldDataCache.Listener>();
        long sizeInBytes = -1L;

        Key(IndexFieldCache indexCache, Object readerKey) {
            this.indexCache = indexCache;
            this.readerKey = readerKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Key key = (Key)o;
            if (!this.indexCache.equals(key.indexCache)) {
                return false;
            }
            return this.readerKey.equals(key.readerKey);
        }

        public int hashCode() {
            int result = this.indexCache.hashCode();
            result = 31 * result + this.readerKey.hashCode();
            return result;
        }
    }

    static class IndexFieldCache
    implements IndexFieldDataCache,
    SegmentReader.CoreClosedListener,
    IndexReader.ReaderClosedListener {
        private final ESLogger logger;
        private final IndexService indexService;
        final Index index;
        final FieldMapper.Names fieldNames;
        final FieldDataType fieldDataType;
        private final Cache<Key, RamUsage> cache;
        private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;

        IndexFieldCache(ESLogger logger, Cache<Key, RamUsage> cache, IndicesFieldDataCacheListener indicesFieldDataCacheListener, IndexService indexService, Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
            this.logger = logger;
            this.indexService = indexService;
            this.index = index;
            this.fieldNames = fieldNames;
            this.fieldDataType = fieldDataType;
            this.cache = cache;
            this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
            assert (indexService != null);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(final AtomicReaderContext context, final IFD indexFieldData) throws Exception {
            final Key key = new Key(this, context.reader().getCoreCacheKey());
            return (FD)((AtomicFieldData)this.cache.get(key, (Callable<RamUsage>)new Callable<AtomicFieldData>(){

                @Override
                public AtomicFieldData call() throws Exception {
                    IndexShard shard;
                    SegmentReaderUtils.registerCoreListener(context.reader(), IndexFieldCache.this);
                    key.listeners.add(IndexFieldCache.this.indicesFieldDataCacheListener);
                    ShardId shardId = ShardUtils.extractShardId(context.reader());
                    if (shardId != null && (shard = IndexFieldCache.this.indexService.shard(shardId.id())) != null) {
                        key.listeners.add(shard.fieldData());
                    }
                    Object fieldData = indexFieldData.loadDirect(context);
                    for (IndexFieldDataCache.Listener listener : key.listeners) {
                        try {
                            listener.onLoad(IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, (RamUsage)fieldData);
                        }
                        catch (Throwable e) {
                            IndexFieldCache.this.logger.error("Failed to call listener on atomic field data loading", e, new Object[0]);
                        }
                    }
                    key.sizeInBytes = fieldData.getMemorySizeInBytes();
                    return fieldData;
                }
            }));
        }

        @Override
        public <IFD extends IndexFieldData.WithOrdinals<?>> IFD load(final IndexReader indexReader, final IFD indexFieldData) throws Exception {
            final Key key = new Key(this, indexReader.getCoreCacheKey());
            return (IFD)((IndexFieldData.WithOrdinals)((Object)this.cache.get(key, new Callable<RamUsage>(){

                @Override
                public RamUsage call() throws Exception {
                    IndexShard shard;
                    indexReader.addReaderClosedListener(IndexFieldCache.this);
                    key.listeners.add(IndexFieldCache.this.indicesFieldDataCacheListener);
                    ShardId shardId = ShardUtils.extractShardId(indexReader);
                    if (shardId != null && (shard = IndexFieldCache.this.indexService.shard(shardId.id())) != null) {
                        key.listeners.add(shard.fieldData());
                    }
                    GlobalOrdinalsIndexFieldData ifd = (GlobalOrdinalsIndexFieldData)indexFieldData.localGlobalDirect(indexReader);
                    for (IndexFieldDataCache.Listener listener : key.listeners) {
                        try {
                            listener.onLoad(IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, ifd);
                        }
                        catch (Throwable e) {
                            IndexFieldCache.this.logger.error("Failed to call listener on global ordinals loading", e, new Object[0]);
                        }
                    }
                    return ifd;
                }
            })));
        }

        @Override
        public void onClose(Object coreKey) {
            this.cache.invalidate(new Key(this, coreKey));
        }

        @Override
        public void onClose(IndexReader reader) {
            this.cache.invalidate(new Key(this, reader.getCoreCacheKey()));
        }

        @Override
        public void clear() {
            for (Key key : this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index)) continue;
                this.cache.invalidate(key);
            }
        }

        @Override
        public void clear(String fieldName) {
            for (Key key : this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index) || !key.indexCache.fieldNames.fullName().equals(fieldName)) continue;
                this.cache.invalidate(key);
            }
        }

        @Override
        public void clear(Object coreCacheKey) {
            this.cache.invalidate(new Key(this, coreCacheKey));
        }
    }

    public static class FieldDataWeigher
    implements Weigher<Key, RamUsage> {
        @Override
        public int weigh(Key key, RamUsage ramUsage) {
            int weight = (int)Math.min(ramUsage.getMemorySizeInBytes(), Integer.MAX_VALUE);
            return weight == 0 ? 1 : weight;
        }
    }
}

