/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class TermsQueryParser
implements QueryParser {
    public static final String NAME = "terms";

    @Inject
    public TermsQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        block20: {
            XContentParser.Token token;
            XContentParser parser = parseContext.parser();
            String fieldName = null;
            boolean disableCoord = false;
            float boost = 1.0f;
            String minimumShouldMatch = null;
            ArrayList<Object> values = Lists.newArrayList();
            String queryName = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    fieldName = currentFieldName;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Object value = parser.objectBytes();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for terms query");
                        }
                        values.add(value);
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                        disableCoord = parser.booleanValue();
                        continue;
                    }
                    if ("minimum_match".equals(currentFieldName) || "minimumMatch".equals(currentFieldName)) {
                        minimumShouldMatch = parser.textOrNull();
                        continue;
                    }
                    if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                        minimumShouldMatch = parser.textOrNull();
                        continue;
                    }
                    if ("boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if ("_name".equals(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[terms] query does not support [" + currentFieldName + "]");
                }
                throw new QueryParsingException(parseContext.index(), "[terms] query does not support [" + currentFieldName + "]");
            }
            if (fieldName == null) {
                throw new QueryParsingException(parseContext.index(), "No field specified for terms query");
            }
            FieldMapper mapper = null;
            MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
            String[] previousTypes = null;
            if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                mapper = smartNameFieldMappers.mapper();
                if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                }
            }
            try {
                BooleanQuery booleanQuery = new BooleanQuery(disableCoord);
                for (Object query2 : values) {
                    if (mapper != null) {
                        booleanQuery.add(new BooleanClause(mapper.termQuery(query2, parseContext), BooleanClause.Occur.SHOULD));
                        continue;
                    }
                    booleanQuery.add(new TermQuery(new Term(fieldName, BytesRefs.toString(query2))), BooleanClause.Occur.SHOULD);
                }
                booleanQuery.setBoost(boost);
                Queries.applyMinimumShouldMatch(booleanQuery, minimumShouldMatch);
                Query query2 = QueryParsers.wrapSmartNameQuery(Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(booleanQuery)), smartNameFieldMappers, parseContext);
                if (queryName != null) {
                    parseContext.addNamedQuery(queryName, query2);
                }
                query = query2;
                if (smartNameFieldMappers == null || !smartNameFieldMappers.explicitTypeInNameWithDocMapper()) break block20;
            }
            catch (Throwable throwable) {
                if (smartNameFieldMappers != null && smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    QueryParseContext.setTypes(previousTypes);
                }
                throw throwable;
            }
            QueryParseContext.setTypes(previousTypes);
        }
        return query;
    }
}

