/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.indexing.IndexingOperationListener;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.percolator.QueriesLoaderCollector;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;

public class PercolatorQueriesRegistry
extends AbstractIndexShardComponent {
    private final IndexQueryParserService queryParserService;
    private final MapperService mapperService;
    private final IndicesLifecycle indicesLifecycle;
    private final IndexCache indexCache;
    private final IndexFieldDataService indexFieldDataService;
    private final ShardIndexingService indexingService;
    private final ShardPercolateService shardPercolateService;
    private final ConcurrentMap<HashedBytesRef, Query> percolateQueries = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final ShardLifecycleListener shardLifecycleListener = new ShardLifecycleListener();
    private final RealTimePercolatorOperationListener realTimePercolatorOperationListener = new RealTimePercolatorOperationListener();
    private final PercolateTypeListener percolateTypeListener = new PercolateTypeListener();
    private final AtomicBoolean realTimePercolatorEnabled = new AtomicBoolean(false);

    @Inject
    public PercolatorQueriesRegistry(ShardId shardId, @IndexSettings Settings indexSettings, IndexQueryParserService queryParserService, ShardIndexingService indexingService, IndicesLifecycle indicesLifecycle, MapperService mapperService, IndexCache indexCache, IndexFieldDataService indexFieldDataService, ShardPercolateService shardPercolateService) {
        super(shardId, indexSettings);
        this.queryParserService = queryParserService;
        this.mapperService = mapperService;
        this.indicesLifecycle = indicesLifecycle;
        this.indexingService = indexingService;
        this.indexCache = indexCache;
        this.indexFieldDataService = indexFieldDataService;
        this.shardPercolateService = shardPercolateService;
        indicesLifecycle.addListener(this.shardLifecycleListener);
        mapperService.addTypeListener(this.percolateTypeListener);
    }

    public ConcurrentMap<HashedBytesRef, Query> percolateQueries() {
        return this.percolateQueries;
    }

    public void close() {
        this.mapperService.removeTypeListener(this.percolateTypeListener);
        this.indicesLifecycle.removeListener(this.shardLifecycleListener);
        this.indexingService.removeListener(this.realTimePercolatorOperationListener);
        this.clear();
    }

    public void clear() {
        this.percolateQueries.clear();
    }

    void enableRealTimePercolator() {
        if (this.realTimePercolatorEnabled.compareAndSet(false, true)) {
            this.indexingService.addListener(this.realTimePercolatorOperationListener);
        }
    }

    void disableRealTimePercolator() {
        if (this.realTimePercolatorEnabled.compareAndSet(true, false)) {
            this.indexingService.removeListener(this.realTimePercolatorOperationListener);
        }
    }

    public void addPercolateQuery(String idAsString, BytesReference source) {
        Query newquery = this.parsePercolatorDocument(idAsString, source);
        HashedBytesRef id = new HashedBytesRef(new BytesRef(idAsString));
        Query previousQuery = this.percolateQueries.put(id, newquery);
        this.shardPercolateService.addedQuery(id, previousQuery, newquery);
    }

    public void removePercolateQuery(String idAsString) {
        HashedBytesRef id = new HashedBytesRef(idAsString);
        Query query = (Query)this.percolateQueries.remove(id);
        if (query != null) {
            this.shardPercolateService.removedQuery(id, query);
        }
    }

    Query parsePercolatorDocument(String id, BytesReference source) {
        String type = null;
        BytesReference querySource = null;
        try (XContentParser parser = null;){
            Query query;
            parser = XContentHelper.createParser(source);
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchException("failed to parse query [" + id + "], not starting with OBJECT");
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("query".equals(currentFieldName)) {
                        if (type != null) {
                            query = this.parseQuery(type, null, parser);
                            return query;
                        }
                        XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());
                        builder.copyCurrentStructure(parser);
                        querySource = builder.bytes();
                        builder.close();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    parser.skipChildren();
                    continue;
                }
                if (!token.isValue() || !"type".equals(currentFieldName)) continue;
                type = parser.text();
            }
            query = this.parseQuery(type, querySource, null);
            return query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query parseQuery(String type, BytesReference querySource, XContentParser parser) {
        if (type == null) {
            if (parser != null) {
                return this.queryParserService.parse(parser).query();
            }
            return this.queryParserService.parse(querySource).query();
        }
        String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{type});
        try {
            if (parser != null) {
                Query query = this.queryParserService.parse(parser).query();
                return query;
            }
            Query query = this.queryParserService.parse(querySource).query();
            return query;
        }
        finally {
            QueryParseContext.setTypes(previousTypes);
        }
    }

    private class RealTimePercolatorOperationListener
    extends IndexingOperationListener {
        private RealTimePercolatorOperationListener() {
        }

        @Override
        public Engine.Create preCreate(Engine.Create create) {
            if (".percolator".equals(create.type())) {
                PercolatorQueriesRegistry.this.parsePercolatorDocument(create.id(), create.source());
            }
            return create;
        }

        @Override
        public void postCreateUnderLock(Engine.Create create) {
            if (".percolator".equals(create.type())) {
                PercolatorQueriesRegistry.this.addPercolateQuery(create.id(), create.source());
            }
        }

        @Override
        public Engine.Index preIndex(Engine.Index index) {
            if (".percolator".equals(index.type())) {
                PercolatorQueriesRegistry.this.parsePercolatorDocument(index.id(), index.source());
            }
            return index;
        }

        @Override
        public void postIndexUnderLock(Engine.Index index) {
            if (".percolator".equals(index.type())) {
                PercolatorQueriesRegistry.this.addPercolateQuery(index.id(), index.source());
            }
        }

        @Override
        public void postDeleteUnderLock(Engine.Delete delete) {
            if (".percolator".equals(delete.type())) {
                PercolatorQueriesRegistry.this.removePercolateQuery(delete.id());
            }
        }
    }

    private class ShardLifecycleListener
    extends IndicesLifecycle.Listener {
        private ShardLifecycleListener() {
        }

        @Override
        public void afterIndexShardCreated(IndexShard indexShard) {
            if (this.hasPercolatorType(indexShard)) {
                PercolatorQueriesRegistry.this.enableRealTimePercolator();
            }
        }

        @Override
        public void afterIndexShardPostRecovery(IndexShard indexShard) {
            if (this.hasPercolatorType(indexShard)) {
                PercolatorQueriesRegistry.this.logger.debug("loading percolator queries for index [{}] and shard[{}]...", PercolatorQueriesRegistry.this.shardId.index(), PercolatorQueriesRegistry.this.shardId.id());
                this.loadQueries(indexShard);
                PercolatorQueriesRegistry.this.logger.trace("done loading percolator queries for index [{}] and shard[{}]", PercolatorQueriesRegistry.this.shardId.index(), PercolatorQueriesRegistry.this.shardId.id());
            }
        }

        private boolean hasPercolatorType(IndexShard indexShard) {
            ShardId otherShardId = indexShard.shardId();
            return PercolatorQueriesRegistry.this.shardId.equals(otherShardId) && PercolatorQueriesRegistry.this.mapperService.hasMapping(".percolator");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadQueries(IndexShard shard) {
            try {
                shard.refresh(new Engine.Refresh("percolator_load_queries").force(true));
                try (Engine.Searcher searcher = shard.acquireSearcher("percolator_load_queries", IndexShard.Mode.WRITE);){
                    XConstantScoreQuery query = new XConstantScoreQuery(PercolatorQueriesRegistry.this.indexCache.filter().cache(new TermFilter(new Term("_type", ".percolator"))));
                    QueriesLoaderCollector queryCollector = new QueriesLoaderCollector(PercolatorQueriesRegistry.this, PercolatorQueriesRegistry.this.logger, PercolatorQueriesRegistry.this.mapperService, PercolatorQueriesRegistry.this.indexFieldDataService);
                    searcher.searcher().search((Query)query, queryCollector);
                    Map<HashedBytesRef, Query> queries = queryCollector.queries();
                    for (Map.Entry<HashedBytesRef, Query> entry : queries.entrySet()) {
                        Query previousQuery = PercolatorQueriesRegistry.this.percolateQueries.put(entry.getKey(), entry.getValue());
                        PercolatorQueriesRegistry.this.shardPercolateService.addedQuery(entry.getKey(), previousQuery, entry.getValue());
                    }
                }
            }
            catch (Exception e) {
                throw new PercolatorException(PercolatorQueriesRegistry.this.shardId.index(), "failed to load queries from percolator index", e);
            }
        }
    }

    private class PercolateTypeListener
    implements DocumentTypeListener {
        private PercolateTypeListener() {
        }

        @Override
        public void beforeCreate(DocumentMapper mapper) {
            if (".percolator".equals(mapper.type())) {
                PercolatorQueriesRegistry.this.enableRealTimePercolator();
            }
        }

        @Override
        public void afterRemove(DocumentMapper mapper) {
            if (".percolator".equals(mapper.type())) {
                PercolatorQueriesRegistry.this.disableRealTimePercolator();
                PercolatorQueriesRegistry.this.clear();
            }
        }
    }
}

