/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.DoubleOpenHashSet;
import org.elasticsearch.common.hppc.LongArrayList;
import org.elasticsearch.common.hppc.LongOpenHashSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.FieldDataTermsFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class NumberFieldMapper<T extends Number>
extends AbstractFieldMapper<T>
implements AllFieldMapper.IncludeInAll {
    protected int precisionStep;
    protected Boolean includeInAll;
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> coerce;
    private ThreadLocal<NumericTokenStream> tokenStream = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(NumberFieldMapper.this.precisionStep);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStream4 = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(4);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStream8 = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(8);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStream16 = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(16);
        }
    };
    private static ThreadLocal<NumericTokenStream> tokenStreamMax = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(Integer.MAX_VALUE);
        }
    };

    protected NumberFieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Boolean docValues, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, boost, fieldType, docValues, indexAnalyzer, searchAnalyzer, postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
        this.precisionStep = precisionStep <= 0 || precisionStep >= this.maxPrecisionStep() ? Integer.MAX_VALUE : precisionStep;
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void unsetIncludeInAll() {
        this.includeInAll = null;
    }

    protected abstract int maxPrecisionStep();

    public int precisionStep() {
        return this.precisionStep;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        RuntimeException e = null;
        try {
            this.innerParseCreateField(context, fields);
        }
        catch (IllegalArgumentException e1) {
            e = e1;
        }
        catch (MapperParsingException e2) {
            e = e2;
        }
        if (e != null && !this.ignoreMalformed.value().booleanValue()) {
            throw e;
        }
    }

    protected abstract void innerParseCreateField(ParseContext var1, List<Field> var2) throws IOException;

    protected final void addDocValue(ParseContext context, long value) {
        CustomLongNumericDocValuesField field = (CustomLongNumericDocValuesField)context.doc().getByKey(this.names().indexName());
        if (field != null) {
            field.add(value);
        } else {
            field = new CustomLongNumericDocValuesField(this.names().indexName(), value);
            context.doc().addWithKey(this.names().indexName(), field);
        }
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        return this.rangeQuery(value, value, true, true, context);
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        return this.rangeFilter(value, value, true, true, context);
    }

    @Override
    public abstract Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Filter rangeFilter(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Query fuzzyQuery(String var1, Fuzziness var2, int var3, int var4, boolean var5);

    public abstract Filter rangeFilter(IndexFieldDataService var1, Object var2, Object var3, boolean var4, boolean var5, @Nullable QueryParseContext var6);

    @Override
    public Filter termsFilter(IndexFieldDataService fieldDataService, List values, @Nullable QueryParseContext context) {
        IndexNumericFieldData fieldData = (IndexNumericFieldData)fieldDataService.getForField(this);
        if (fieldData.getNumericType().isFloatingPoint()) {
            DoubleOpenHashSet terms = new DoubleOpenHashSet((int)((float)values.size() * 1.75f));
            int len = values.size();
            for (int i = 0; i < len; ++i) {
                terms.add(this.parseDoubleValue(values.get(i)));
            }
            return FieldDataTermsFilter.newDoubles(fieldData, terms);
        }
        LongOpenHashSet terms = new LongOpenHashSet((int)((float)values.size() * 1.75f));
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            terms.add(this.parseLongValue(values.get(i)));
        }
        return FieldDataTermsFilter.newLongs(fieldData, terms);
    }

    public double parseDoubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BytesRef) {
            return Double.parseDouble(((BytesRef)value).utf8ToString());
        }
        return Double.parseDouble(value.toString());
    }

    public long parseLongValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return Long.parseLong(((BytesRef)value).utf8ToString());
        }
        return Long.parseLong(value.toString());
    }

    @Override
    public Object valueForSearch(Object value) {
        return this.value(value);
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            NumberFieldMapper nfmMergeWith = (NumberFieldMapper)mergeWith;
            this.precisionStep = nfmMergeWith.precisionStep;
            this.includeInAll = nfmMergeWith.includeInAll;
            if (nfmMergeWith.ignoreMalformed.explicit()) {
                this.ignoreMalformed = nfmMergeWith.ignoreMalformed;
            }
            if (nfmMergeWith.coerce.explicit()) {
                this.coerce = nfmMergeWith.coerce;
            }
        }
    }

    @Override
    public void close() {
    }

    protected NumericTokenStream popCachedStream() {
        if (this.precisionStep == 4) {
            return tokenStream4.get();
        }
        if (this.precisionStep == 8) {
            return tokenStream8.get();
        }
        if (this.precisionStep == 16) {
            return tokenStream16.get();
        }
        if (this.precisionStep == Integer.MAX_VALUE) {
            return tokenStreamMax.get();
        }
        return this.tokenStream.get();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", (Object)this.coerce.value());
        }
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public static class CustomLongNumericDocValuesField
    extends CustomNumericDocValuesField {
        public static final FieldType TYPE = new FieldType();
        private final LongArrayList values = new LongArrayList();

        public CustomLongNumericDocValuesField(String name, long value) {
            super(name);
            this.add(value);
        }

        public void add(long value) {
            this.values.add(value);
        }

        @Override
        public BytesRef binaryValue() {
            CollectionUtils.sortAndDedup(this.values);
            byte[] bytes = new byte[this.values.size() * 9];
            ByteArrayDataOutput out = new ByteArrayDataOutput(bytes);
            ByteUtils.writeVLong(out, ByteUtils.zigZagEncode(this.values.get(0)));
            for (int i = 1; i < this.values.size(); ++i) {
                long delta = this.values.get(i) - this.values.get(i - 1);
                ByteUtils.writeVLong(out, delta);
            }
            return new BytesRef(bytes, 0, out.getPosition());
        }

        static {
            TYPE.setDocValueType(FieldInfo.DocValuesType.BINARY);
            TYPE.freeze();
        }
    }

    public static abstract class CustomNumericDocValuesField
    implements IndexableField {
        public static final FieldType TYPE = new FieldType();
        private final String name;

        public CustomNumericDocValuesField(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public IndexableFieldType fieldType() {
            return TYPE;
        }

        @Override
        public float boost() {
            return 1.0f;
        }

        @Override
        public String stringValue() {
            return null;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        @Override
        public Number numericValue() {
            return null;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer) throws IOException {
            return null;
        }

        static {
            TYPE.setDocValueType(FieldInfo.DocValuesType.BINARY);
            TYPE.freeze();
        }
    }

    public static abstract class CustomNumericField
    extends Field {
        protected final NumberFieldMapper mapper;

        public CustomNumericField(NumberFieldMapper mapper, Number value, FieldType fieldType) {
            super(mapper.names().indexName(), fieldType);
            this.mapper = mapper;
            if (value != null) {
                this.fieldsData = value;
            }
        }

        @Override
        public String stringValue() {
            return null;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        public abstract String numericAsString();
    }

    public static abstract class Builder<T extends Builder, Y extends NumberFieldMapper>
    extends AbstractFieldMapper.Builder<T, Y> {
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name, FieldType fieldType, int defaultPrecisionStep) {
            super(name, fieldType);
            fieldType.setNumericPrecisionStep(defaultPrecisionStep);
        }

        public T precisionStep(int precisionStep) {
            this.fieldType.setNumericPrecisionStep(precisionStep);
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public T coerce(boolean coerce) {
            this.coerce = coerce;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.coerce", Defaults.COERCE.value()), false);
            }
            return Defaults.COERCE;
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final int PRECISION_STEP_8_BIT = Integer.MAX_VALUE;
        public static final int PRECISION_STEP_16_BIT = 8;
        public static final int PRECISION_STEP_32_BIT = 8;
        public static final int PRECISION_STEP_64_BIT = 16;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final Explicit<Boolean> IGNORE_MALFORMED;
        public static final Explicit<Boolean> COERCE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.freeze();
            IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
            COERCE = new Explicit<Boolean>(true, false);
        }
    }
}

