/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsTranslog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final ThreadPool threadPool;
    private final InternalIndexShard indexShard;
    private final RecoveryState recoveryState = new RecoveryState();
    private volatile ScheduledFuture flushScheduler;
    private final TimeValue syncInterval;

    @Inject
    public LocalIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexShard = (InternalIndexShard)indexShard;
        this.syncInterval = this.componentSettings.getAsTime("sync", TimeValue.timeValueSeconds(5L));
        if (this.syncInterval.millis() > 0L) {
            this.indexShard.translog().syncOnEachOperation(false);
            this.flushScheduler = threadPool.schedule(this.syncInterval, "same", new Sync());
        } else if (this.syncInterval.millis() == 0L) {
            this.flushScheduler = null;
            this.indexShard.translog().syncOnEachOperation(true);
        } else {
            this.flushScheduler = null;
        }
    }

    public String toString() {
        return "local";
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    @Override
    public void recover(boolean indexShouldExists, RecoveryState recoveryState) throws IndexShardGatewayRecoveryException {
        recoveryState.getIndex().startTime(System.currentTimeMillis());
        recoveryState.setStage(RecoveryState.Stage.INDEX);
        long version = -1L;
        long translogId = -1L;
        try {
            SegmentInfos si;
            block33: {
                si = null;
                try {
                    si = Lucene.readSegmentInfos(this.indexShard.store().directory());
                }
                catch (Throwable e) {
                    String files = "_unknown_";
                    try {
                        files = Arrays.toString(this.indexShard.store().directory().listAll());
                    }
                    catch (Throwable e1) {
                        files = files + " (failure=" + ExceptionsHelper.detailedMessage(e1) + ")";
                    }
                    if (!indexShouldExists || !this.indexShard.store().indexStore().persistent()) break block33;
                    throw new IndexShardGatewayRecoveryException(this.shardId(), "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + files, e);
                }
            }
            if (si != null) {
                if (indexShouldExists) {
                    version = si.getVersion();
                    translogId = si.getUserData().containsKey("translog_id") ? Long.parseLong(si.getUserData().get("translog_id")) : version;
                    this.logger.trace("using existing shard data, translog id [{}]", translogId);
                } else {
                    this.logger.trace("cleaning existing shard, shouldn't exists", new Object[0]);
                    IndexWriter writer = new IndexWriter(this.indexShard.store().directory(), new IndexWriterConfig(Lucene.VERSION, Lucene.STANDARD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                    writer.close();
                }
            }
        }
        catch (Throwable e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "failed to fetch index version after copying it over", e);
        }
        recoveryState.getIndex().updateVersion(version);
        recoveryState.getIndex().time(System.currentTimeMillis() - recoveryState.getIndex().startTime());
        try {
            int numberOfFiles = 0;
            long totalSizeInBytes = 0L;
            for (String name : this.indexShard.store().directory().listAll()) {
                ++numberOfFiles;
                long length = this.indexShard.store().directory().fileLength(name);
                totalSizeInBytes += length;
                recoveryState.getIndex().addFileDetail(name, length, length);
            }
            recoveryState.getIndex().files(numberOfFiles, totalSizeInBytes, numberOfFiles, totalSizeInBytes);
            recoveryState.getIndex().recoveredFileCount(numberOfFiles);
            recoveryState.getIndex().recoveredByteCount(totalSizeInBytes);
        }
        catch (Exception e) {
            // empty catch block
        }
        recoveryState.getStart().startTime(System.currentTimeMillis());
        recoveryState.setStage(RecoveryState.Stage.START);
        if (translogId == -1L) {
            this.indexShard.postRecovery("post recovery from gateway, no translog");
            recoveryState.getStart().time(System.currentTimeMillis() - recoveryState.getStart().startTime());
            recoveryState.getStart().checkIndexTime(this.indexShard.checkIndexTook());
            return;
        }
        FsTranslog translog = (FsTranslog)this.indexShard.translog();
        String translogName = "translog-" + translogId;
        String recoverTranslogName = translogName + ".recovering";
        File recoveringTranslogFile = null;
        block23: for (File translogLocation : translog.locations()) {
            File tmpRecoveringFile = new File(translogLocation, recoverTranslogName);
            if (!tmpRecoveringFile.exists()) {
                File tmpTranslogFile = new File(translogLocation, translogName);
                if (!tmpTranslogFile.exists()) continue;
                for (int i = 0; i < 3; ++i) {
                    if (!tmpTranslogFile.renameTo(tmpRecoveringFile)) continue;
                    recoveringTranslogFile = tmpRecoveringFile;
                    continue block23;
                }
                continue;
            }
            recoveringTranslogFile = tmpRecoveringFile;
            break;
        }
        if (recoveringTranslogFile == null || !recoveringTranslogFile.exists()) {
            this.indexShard.postRecovery("post recovery from gateway, no translog");
            recoveryState.getStart().time(System.currentTimeMillis() - recoveryState.getStart().startTime());
            recoveryState.getStart().checkIndexTime(this.indexShard.checkIndexTook());
            return;
        }
        this.indexShard.performRecoveryPrepareForTranslog();
        recoveryState.getStart().time(System.currentTimeMillis() - recoveryState.getStart().startTime());
        recoveryState.getStart().checkIndexTime(this.indexShard.checkIndexTook());
        recoveryState.getTranslog().startTime(System.currentTimeMillis());
        recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(recoveringTranslogFile);
            InputStreamStreamInput si = new InputStreamStreamInput(fs);
            while (true) {
                Translog.Operation operation;
                try {
                    int opSize = si.readInt();
                    operation = TranslogStreams.readTranslogOperation(si);
                }
                catch (EOFException e) {
                    break;
                }
                catch (IOException e) {
                    break;
                }
                try {
                    this.indexShard.performRecoveryOperation(operation);
                    recoveryState.getTranslog().addTranslogOperations(1);
                    continue;
                }
                catch (ElasticsearchException e) {
                    if (e.status() == RestStatus.BAD_REQUEST) {
                        this.logger.info("ignoring recovery of a corrupt translog entry", e, new Object[0]);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        catch (Throwable e) {
            this.indexShard.translog().closeWithDelete();
            throw new IndexShardGatewayRecoveryException(this.shardId, "failed to recover shard", e);
        }
        finally {
            try {
                fs.close();
            }
            catch (IOException e) {}
        }
        this.indexShard.performRecoveryFinalization(true);
        recoveringTranslogFile.delete();
        recoveryState.getTranslog().time(System.currentTimeMillis() - recoveryState.getTranslog().startTime());
    }

    @Override
    public String type() {
        return "local";
    }

    @Override
    public void close() {
        if (this.flushScheduler != null) {
            this.flushScheduler.cancel(false);
        }
    }

    class Sync
    implements Runnable {
        Sync() {
        }

        @Override
        public void run() {
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.CLOSED) {
                return;
            }
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.STARTED && LocalIndexShardGateway.this.indexShard.translog().syncNeeded()) {
                LocalIndexShardGateway.this.threadPool.executor("flush").execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                LocalIndexShardGateway.this.indexShard.translog().sync();
                            }
                            catch (Exception e) {
                                if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.STARTED) break block3;
                                LocalIndexShardGateway.this.logger.warn("failed to sync translog", e, new Object[0]);
                            }
                        }
                        if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.CLOSED) {
                            LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", Sync.this);
                        }
                    }
                });
            } else {
                LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", this);
            }
        }
    }
}

