/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

abstract class SortedSetDVAtomicFieldData {
    private final AtomicReader reader;
    private final String field;
    private volatile IntArray hashes;

    SortedSetDVAtomicFieldData(AtomicReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    public boolean isMultiValued() {
        return true;
    }

    public long getNumberUniqueValues() {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        return values.getValueCount();
    }

    public long getMemorySizeInBytes() {
        return -1L;
    }

    public void close() {
    }

    public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        return new SortedSetValues(this.reader, this.field, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesValues.WithOrdinals getHashedBytesValues() {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        if (this.hashes == null) {
            SortedSetDVAtomicFieldData sortedSetDVAtomicFieldData = this;
            synchronized (sortedSetDVAtomicFieldData) {
                if (this.hashes == null) {
                    long valueCount = values.getValueCount();
                    IntArray hashes = BigArrays.NON_RECYCLING_INSTANCE.newIntArray(valueCount);
                    BytesRef scratch = new BytesRef(16);
                    for (long i = 0L; i < valueCount; ++i) {
                        values.lookupOrd(i, scratch);
                        hashes.set(i, scratch.hashCode());
                    }
                    this.hashes = hashes;
                }
            }
        }
        return new SortedSetHashedValues(this.reader, this.field, values, this.hashes);
    }

    public TermsEnum getTermsEnum() {
        return SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field).termsEnum();
    }

    private static SortedSetDocValues getValuesNoException(AtomicReader reader, String field) {
        try {
            SortedSetDocValues values = reader.getSortedSetDocValues(field);
            if (values == null) {
                assert (reader.getFieldInfos().fieldInfo(field) == null);
                values = DocValues.EMPTY_SORTED_SET;
            }
            return values;
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Couldn't load doc values", e);
        }
    }

    static class SortedSetDocs
    extends Ordinals.AbstractDocs {
        private final SortedSetDocValues values;
        private long[] ords;
        private int ordIndex = Integer.MAX_VALUE;
        private long currentOrdinal = -1L;

        SortedSetDocs(SortedSetOrdinals ordinals, SortedSetDocValues values) {
            super(ordinals);
            this.values = values;
            this.ords = new long[0];
        }

        @Override
        public long getOrd(int docId) {
            this.values.setDocument(docId);
            this.currentOrdinal = this.values.nextOrd();
            return this.currentOrdinal;
        }

        @Override
        public long nextOrd() {
            assert (this.ordIndex < this.ords.length);
            this.currentOrdinal = this.ords[this.ordIndex++];
            return this.currentOrdinal;
        }

        @Override
        public int setDocument(int docId) {
            this.values.setDocument(docId);
            int i = 0;
            long ord = this.values.nextOrd();
            while (ord != -1L) {
                this.ords = ArrayUtil.grow(this.ords, i + 1);
                this.ords[i++] = ord;
                ord = this.values.nextOrd();
            }
            this.ordIndex = 0;
            return i;
        }

        @Override
        public long currentOrd() {
            return this.currentOrdinal;
        }
    }

    static final class SortedSetOrdinals
    implements Ordinals {
        private final AtomicReader reader;
        private final String field;
        private final long maxOrd;

        public SortedSetOrdinals(AtomicReader reader, String field, long numOrds) {
            this.reader = reader;
            this.field = field;
            this.maxOrd = numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            return -1L;
        }

        @Override
        public boolean isMultiValued() {
            return true;
        }

        @Override
        public long getMaxOrd() {
            return this.maxOrd;
        }

        @Override
        public Ordinals.Docs ordinals() {
            SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
            assert (values.getValueCount() == this.maxOrd);
            return new SortedSetDocs(this, values);
        }
    }

    static final class SortedSetHashedValues
    extends SortedSetValues {
        private final IntArray hashes;

        SortedSetHashedValues(AtomicReader reader, String field, SortedSetDocValues values, IntArray hashes) {
            super(reader, field, values);
            this.hashes = hashes;
        }

        @Override
        public int currentValueHash() {
            assert (this.ordinals.currentOrd() >= 0L);
            return this.hashes.get(this.ordinals.currentOrd());
        }
    }

    static class SortedSetValues
    extends BytesValues.WithOrdinals {
        protected final SortedSetDocValues values;

        SortedSetValues(AtomicReader reader, String field, SortedSetDocValues values) {
            super(new SortedSetDocs(new SortedSetOrdinals(reader, field, values.getValueCount()), values));
            this.values = values;
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            assert (ord != -1L);
            this.values.lookupOrd(ord, this.scratch);
            return this.scratch;
        }

        @Override
        public BytesRef nextValue() {
            this.values.lookupOrd(this.ordinals.nextOrd(), this.scratch);
            return this.scratch;
        }
    }
}

