/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class BytesValues {
    public static final BytesValues EMPTY = new Empty();
    private boolean multiValued;
    protected final BytesRef scratch = new BytesRef();
    protected int docId = -1;

    protected BytesValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public BytesRef copyShared() {
        return BytesRef.deepCopyOf(this.scratch);
    }

    public abstract int setDocument(int var1);

    public abstract BytesRef nextValue();

    public int currentValueHash() {
        return this.scratch.hashCode();
    }

    public AtomicFieldData.Order getOrder() {
        return AtomicFieldData.Order.BYTES;
    }

    private static final class Empty
    extends BytesValues {
        Empty() {
            super(false);
        }

        @Override
        public int setDocument(int docId) {
            return 0;
        }

        @Override
        public BytesRef nextValue() {
            throw new ElasticsearchIllegalStateException("Empty BytesValues has no next value");
        }

        @Override
        public int currentValueHash() {
            throw new ElasticsearchIllegalStateException("Empty BytesValues has no hash for the current Value");
        }
    }

    public static abstract class WithOrdinals
    extends BytesValues {
        protected final Ordinals.Docs ordinals;

        protected WithOrdinals(Ordinals.Docs ordinals) {
            super(ordinals.isMultiValued());
            this.ordinals = ordinals;
        }

        public Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        public abstract BytesRef getValueByOrd(long var1);

        @Override
        public int setDocument(int docId) {
            this.docId = docId;
            int length = this.ordinals.setDocument(docId);
            assert (this.ordinals.getOrd(docId) != -1L == length > 0) : "Doc: [" + docId + "] hasValue: [" + (this.ordinals.getOrd(docId) != -1L) + "] but length is [" + length + "]";
            return length;
        }

        @Override
        public BytesRef nextValue() {
            assert (this.docId != -1);
            return this.getValueByOrd(this.ordinals.nextOrd());
        }
    }
}

