/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.docvaluesformat;

import org.apache.lucene.codecs.DocValuesFormat;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.docvaluesformat.PreBuiltDocValuesFormatProvider;

public class DocValuesFormats {
    private static final ImmutableMap<String, PreBuiltDocValuesFormatProvider.Factory> builtInDocValuesFormats;

    public static DocValuesFormatProvider.Factory getAsFactory(String name) {
        return builtInDocValuesFormats.get(name);
    }

    public static DocValuesFormatProvider getAsProvider(String name) {
        PreBuiltDocValuesFormatProvider.Factory factory = builtInDocValuesFormats.get(name);
        return factory == null ? null : factory.get();
    }

    public static ImmutableCollection<PreBuiltDocValuesFormatProvider.Factory> listFactories() {
        return builtInDocValuesFormats.values();
    }

    static {
        MapBuilder<String, PreBuiltDocValuesFormatProvider.Factory> builtInDocValuesFormatsX = MapBuilder.newMapBuilder();
        for (String name : DocValuesFormat.availableDocValuesFormats()) {
            builtInDocValuesFormatsX.put(name, new PreBuiltDocValuesFormatProvider.Factory(DocValuesFormat.forName(name)));
        }
        builtInDocValuesFormatsX.put("default", new PreBuiltDocValuesFormatProvider.Factory("default", DocValuesFormat.forName("Lucene45")));
        builtInDocValuesFormatsX.put("memory", new PreBuiltDocValuesFormatProvider.Factory("memory", DocValuesFormat.forName("Memory")));
        builtInDocValuesFormatsX.put("disk", new PreBuiltDocValuesFormatProvider.Factory("disk", DocValuesFormat.forName("Disk")));
        builtInDocValuesFormats = builtInDocValuesFormatsX.immutableMap();
    }
}

