/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.Strings;

public interface CacheKeyFilter {
    public Object cacheKey();

    public static class Wrapper
    extends Filter
    implements CacheKeyFilter {
        private final Filter filter;
        private final Key key;

        public Wrapper(Filter filter, Key key) {
            this.filter = filter;
            this.key = key;
        }

        @Override
        public Key cacheKey() {
            return this.key;
        }

        public Filter wrappedFilter() {
            return this.filter;
        }

        @Override
        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            return this.filter.getDocIdSet(context, acceptDocs);
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            return this.filter.equals(obj);
        }

        public String toString() {
            return this.filter.toString();
        }
    }

    public static class Key {
        private final byte[] bytes;
        private final int hashCode;

        public Key(byte[] bytes) {
            this.bytes = bytes;
            this.hashCode = Arrays.hashCode(bytes);
        }

        public Key(String str) {
            this(Strings.toUTF8Bytes(str));
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Key bytesWrap = (Key)o;
            return Arrays.equals(this.bytes, bytesWrap.bytes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

