/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.smile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentGenerator;
import org.elasticsearch.common.xcontent.smile.SmileXContent;

public class SmileXContentGenerator
extends JsonXContentGenerator {
    public SmileXContentGenerator(JsonGenerator generator) {
        super(generator);
    }

    @Override
    public XContentType contentType() {
        return XContentType.SMILE;
    }

    @Override
    public void usePrintLineFeedAtEnd() {
    }

    @Override
    public void writeRawField(String fieldName, InputStream content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = SmileXContent.smileFactory.createParser(content);){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }

    @Override
    public void writeRawField(String fieldName, byte[] content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = SmileXContent.smileFactory.createParser(content);){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectRaw(String fieldName, BytesReference content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = content.hasArray() ? SmileXContent.smileFactory.createParser(content.array(), content.arrayOffset(), content.length()) : SmileXContent.smileFactory.createParser(content.streamInput());){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }

    @Override
    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = SmileXContent.smileFactory.createParser(content, offset, length);){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }
}

