/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.elasticsearch.common.io.FastStringReader;

public class MoreLikeThisQuery
extends Query {
    public static final float DEFAULT_PERCENT_TERMS_TO_MATCH = 0.3f;
    private TFIDFSimilarity similarity;
    private String likeText;
    private String[] moreLikeFields;
    private Analyzer analyzer;
    private float percentTermsToMatch = 0.3f;
    private int minTermFrequency = 2;
    private int maxQueryTerms = 25;
    private Set<?> stopWords = MoreLikeThis.DEFAULT_STOP_WORDS;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private int minWordLen = 0;
    private int maxWordLen = 0;
    private boolean boostTerms = false;
    private float boostTermsFactor = 1.0f;

    public MoreLikeThisQuery() {
    }

    public MoreLikeThisQuery(String likeText, String[] moreLikeFields, Analyzer analyzer) {
        this.likeText = likeText;
        this.moreLikeFields = moreLikeFields;
        this.analyzer = analyzer;
    }

    @Override
    public int hashCode() {
        int result = this.boostTerms ? 1 : 0;
        result = 31 * result + Float.floatToIntBits(this.boostTermsFactor);
        result = 31 * result + this.likeText.hashCode();
        result = 31 * result + this.maxDocFreq;
        result = 31 * result + this.maxQueryTerms;
        result = 31 * result + this.maxWordLen;
        result = 31 * result + this.minDocFreq;
        result = 31 * result + this.minTermFrequency;
        result = 31 * result + this.minWordLen;
        result = 31 * result + Arrays.hashCode(this.moreLikeFields);
        result = 31 * result + Float.floatToIntBits(this.percentTermsToMatch);
        result = 31 * result + (this.stopWords == null ? 0 : this.stopWords.hashCode());
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MoreLikeThisQuery other = (MoreLikeThisQuery)obj;
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (!this.analyzer.equals(other.analyzer)) {
            return false;
        }
        if (this.boostTerms != other.boostTerms) {
            return false;
        }
        if (this.boostTermsFactor != other.boostTermsFactor) {
            return false;
        }
        if (!this.likeText.equals(other.likeText)) {
            return false;
        }
        if (this.maxDocFreq != other.maxDocFreq) {
            return false;
        }
        if (this.maxQueryTerms != other.maxQueryTerms) {
            return false;
        }
        if (this.maxWordLen != other.maxWordLen) {
            return false;
        }
        if (this.minDocFreq != other.minDocFreq) {
            return false;
        }
        if (this.minTermFrequency != other.minTermFrequency) {
            return false;
        }
        if (this.minWordLen != other.minWordLen) {
            return false;
        }
        if (!Arrays.equals(this.moreLikeFields, other.moreLikeFields)) {
            return false;
        }
        if (this.percentTermsToMatch != other.percentTermsToMatch) {
            return false;
        }
        if (this.similarity == null ? other.similarity != null : !this.similarity.equals(other.similarity)) {
            return false;
        }
        return !(this.stopWords == null ? other.stopWords != null : !this.stopWords.equals(other.stopWords));
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        MoreLikeThis mlt = new MoreLikeThis(reader, this.similarity == null ? new DefaultSimilarity() : this.similarity);
        mlt.setFieldNames(this.moreLikeFields);
        mlt.setAnalyzer(this.analyzer);
        mlt.setMinTermFreq(this.minTermFrequency);
        mlt.setMinDocFreq(this.minDocFreq);
        mlt.setMaxDocFreq(this.maxDocFreq);
        mlt.setMaxQueryTerms(this.maxQueryTerms);
        mlt.setMinWordLen(this.minWordLen);
        mlt.setMaxWordLen(this.maxWordLen);
        mlt.setStopWords(this.stopWords);
        mlt.setBoost(this.boostTerms);
        mlt.setBoostFactor(this.boostTermsFactor);
        BooleanQuery bq = (BooleanQuery)mlt.like(new FastStringReader(this.likeText), this.moreLikeFields[0]);
        BooleanClause[] clauses = bq.getClauses();
        bq.setMinimumNumberShouldMatch((int)((float)clauses.length * this.percentTermsToMatch));
        bq.setBoost(this.getBoost());
        return bq;
    }

    @Override
    public String toString(String field) {
        return "like:" + this.likeText;
    }

    public String getLikeText() {
        return this.likeText;
    }

    public void setLikeText(String likeText) {
        this.likeText = likeText;
    }

    public String[] getMoreLikeFields() {
        return this.moreLikeFields;
    }

    public void setMoreLikeFields(String[] moreLikeFields) {
        this.moreLikeFields = moreLikeFields;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        if (similarity == null || similarity instanceof TFIDFSimilarity) {
            this.similarity = (TFIDFSimilarity)similarity;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public float getPercentTermsToMatch() {
        return this.percentTermsToMatch;
    }

    public void setPercentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
    }

    public int getMinTermFrequency() {
        return this.minTermFrequency;
    }

    public void setMinTermFrequency(int minTermFrequency) {
        this.minTermFrequency = minTermFrequency;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public int getMaxDocFreq() {
        return this.maxDocFreq;
    }

    public void setMaxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public int getMinWordLen() {
        return this.minWordLen;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public int getMaxWordLen() {
        return this.maxWordLen;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public boolean isBoostTerms() {
        return this.boostTerms;
    }

    public void setBoostTerms(boolean boostTerms) {
        this.boostTerms = boostTerms;
    }

    public float getBoostTermsFactor() {
        return this.boostTermsFactor;
    }

    public void setBoostTermsFactor(float boostTermsFactor) {
        this.boostTermsFactor = boostTermsFactor;
    }
}

