/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;

public class ApplyAcceptedDocsFilter
extends Filter {
    private final Filter filter;

    public ApplyAcceptedDocsFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSet docIdSet = this.filter.getDocIdSet(context, acceptDocs);
        if (DocIdSets.isEmpty(docIdSet)) {
            return null;
        }
        if (acceptDocs == null) {
            return docIdSet;
        }
        if (acceptDocs == context.reader().getLiveDocs()) {
            return new NotDeletedDocIdSet(docIdSet, acceptDocs);
        }
        return new WrappedDocIdSet(BitsFilteredDocIdSet.wrap(docIdSet, acceptDocs), docIdSet);
    }

    public Filter filter() {
        return this.filter;
    }

    public String toString() {
        return this.filter.toString();
    }

    public static DocIdSet unwrap(DocIdSet docIdSet) {
        if (docIdSet instanceof NotDeletedDocIdSet) {
            return ((NotDeletedDocIdSet)docIdSet).innerSet;
        }
        if (docIdSet instanceof WrappedDocIdSet) {
            return ((WrappedDocIdSet)docIdSet).innerSet;
        }
        return docIdSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplyAcceptedDocsFilter other = (ApplyAcceptedDocsFilter)obj;
        return !(this.filter == null ? other.filter != null : !this.filter.equals(other.filter));
    }

    private static final class WrappedDocIdSet
    extends DocIdSet {
        private final DocIdSet delegate;
        private final DocIdSet innerSet;

        private WrappedDocIdSet(DocIdSet delegate, DocIdSet innerSet) {
            this.delegate = delegate;
            this.innerSet = innerSet;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            return this.delegate.iterator();
        }

        @Override
        public Bits bits() throws IOException {
            return this.delegate.bits();
        }

        @Override
        public boolean isCacheable() {
            return this.delegate.isCacheable();
        }
    }

    static class NotDeletedDocIdSetIterator
    extends FilteredDocIdSetIterator {
        private final Bits match;

        NotDeletedDocIdSetIterator(DocIdSetIterator innerIter, Bits match) {
            super(innerIter);
            this.match = match;
        }

        @Override
        protected boolean match(int doc) {
            return this.match.get(doc);
        }
    }

    static class NotDeleteBits
    implements Bits {
        private final Bits bits;
        private final Bits liveDocs;

        NotDeleteBits(Bits bits, Bits liveDocs) {
            this.bits = bits;
            this.liveDocs = liveDocs;
        }

        @Override
        public boolean get(int index) {
            return this.liveDocs.get(index) && this.bits.get(index);
        }

        @Override
        public int length() {
            return this.bits.length();
        }
    }

    static class NotDeletedDocIdSet
    extends DocIdSet {
        private final DocIdSet innerSet;
        private final Bits liveDocs;

        NotDeletedDocIdSet(DocIdSet innerSet, Bits liveDocs) {
            this.innerSet = innerSet;
            this.liveDocs = liveDocs;
        }

        @Override
        public boolean isCacheable() {
            return this.innerSet.isCacheable();
        }

        @Override
        public Bits bits() throws IOException {
            Bits bits = this.innerSet.bits();
            if (bits == null) {
                return null;
            }
            return new NotDeleteBits(bits, this.liveDocs);
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            Bits bits;
            if (!DocIdSets.isFastIterator(this.innerSet) && this.liveDocs instanceof FixedBitSet && (bits = this.innerSet.bits()) != null) {
                return new NotDeletedDocIdSetIterator(((FixedBitSet)this.liveDocs).iterator(), bits);
            }
            DocIdSetIterator iterator = this.innerSet.iterator();
            if (iterator == null) {
                return null;
            }
            return new NotDeletedDocIdSetIterator(iterator, this.liveDocs);
        }
    }
}

