/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;

public class AndFilter
extends Filter {
    private final List<? extends Filter> filters;

    public AndFilter(List<? extends Filter> filters) {
        this.filters = filters;
    }

    public List<? extends Filter> filters() {
        return this.filters;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getDocIdSet(context, acceptDocs);
        }
        DocIdSet[] sets = new DocIdSet[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            DocIdSet set = this.filters.get(i).getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(set)) {
                return null;
            }
            sets[i] = set;
        }
        return new AndDocIdSet(sets);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.filters ? 0 : this.filters.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AndFilter other = (AndFilter)obj;
        return this.equalFilters(this.filters, other.filters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Filter filter : this.filters) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append('+');
            builder.append(filter);
        }
        return builder.toString();
    }

    private boolean equalFilters(List<? extends Filter> filters1, List<? extends Filter> filters2) {
        return filters1 == filters2 || filters1 != null && filters1.equals(filters2);
    }
}

