/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.BitsDocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocIdSets;

public class AndDocIdSet
extends DocIdSet {
    private final DocIdSet[] sets;

    public AndDocIdSet(DocIdSet[] sets) {
        this.sets = sets;
    }

    @Override
    public boolean isCacheable() {
        for (DocIdSet set : this.sets) {
            if (set.isCacheable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Bits bits() throws IOException {
        Bits[] bits = new Bits[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            bits[i] = this.sets[i].bits();
            if (bits[i] != null) continue;
            return null;
        }
        return new AndBits(bits);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        ArrayList<DocIdSet> iterators = new ArrayList<DocIdSet>(this.sets.length);
        ArrayList<Bits> bits = new ArrayList<Bits>(this.sets.length);
        for (DocIdSet set : this.sets) {
            if (DocIdSets.isFastIterator(set)) {
                iterators.add(set);
                continue;
            }
            Bits bit = set.bits();
            if (bit != null) {
                bits.add(bit);
                continue;
            }
            iterators.add(set);
        }
        if (bits.isEmpty()) {
            return IteratorBasedIterator.newDocIdSetIterator(iterators.toArray(new DocIdSet[iterators.size()]));
        }
        if (iterators.isEmpty()) {
            return new BitsDocIdSetIterator(new AndBits(bits.toArray(new Bits[bits.size()])));
        }
        return new BitsDocIdSetIterator.FilteredIterator(IteratorBasedIterator.newDocIdSetIterator(iterators.toArray(new DocIdSet[iterators.size()])), new AndBits(bits.toArray(new Bits[bits.size()])));
    }

    static class IteratorBasedIterator
    extends DocIdSetIterator {
        private int lastReturn = -1;
        private final DocIdSetIterator[] iterators;
        private final long cost;

        public static DocIdSetIterator newDocIdSetIterator(DocIdSet[] sets) throws IOException {
            if (sets.length == 0) {
                return DocIdSetIterator.empty();
            }
            DocIdSetIterator[] iterators = new DocIdSetIterator[sets.length];
            int j = 0;
            long cost = Integer.MAX_VALUE;
            for (DocIdSet set : sets) {
                if (set == null) {
                    return DocIdSetIterator.empty();
                }
                DocIdSetIterator docIdSetIterator = set.iterator();
                if (docIdSetIterator == null) {
                    return DocIdSetIterator.empty();
                }
                iterators[j++] = docIdSetIterator;
                cost = Math.min(cost, docIdSetIterator.cost());
            }
            if (sets.length == 1) {
                return iterators[0];
            }
            return new IteratorBasedIterator(iterators, cost);
        }

        private IteratorBasedIterator(DocIdSetIterator[] iterators, long cost) throws IOException {
            this.iterators = iterators;
            this.cost = cost;
        }

        @Override
        public final int docID() {
            return this.lastReturn;
        }

        @Override
        public final int nextDoc() throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                assert (false) : "Illegal State - DocIdSetIterator is already exhausted";
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            int target = dcit.nextDoc();
            int size = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        @Override
        public final int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                assert (false) : "Illegal State - DocIdSetIterator is already exhausted";
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            target = dcit.advance(target);
            int size = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        @Override
        public long cost() {
            return this.cost;
        }
    }

    static class AndBits
    implements Bits {
        private final Bits[] bits;

        AndBits(Bits[] bits) {
            this.bits = bits;
        }

        @Override
        public boolean get(int index) {
            for (Bits bit : this.bits) {
                if (bit.get(index)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int length() {
            return this.bits[0].length();
        }
    }
}

