/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.lucene.all.AllTokenStream;

public class AllField
extends Field {
    private final AllEntries allEntries;
    private final Analyzer analyzer;

    public AllField(String name, AllEntries allEntries, Analyzer analyzer, FieldType fieldType) {
        super(name, fieldType);
        this.allEntries = allEntries;
        this.analyzer = analyzer;
    }

    @Override
    public String stringValue() {
        if (this.fieldType().stored()) {
            return this.allEntries.buildText();
        }
        return null;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer) throws IOException {
        try {
            this.allEntries.reset();
            return AllTokenStream.allTokenStream(this.name, this.allEntries, analyzer);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create token stream");
        }
    }
}

