/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.text.Text;

public abstract class StreamOutput
extends OutputStream {
    private Version version = Version.CURRENT;
    private final BytesRef spare = new BytesRef();
    private static byte ZERO = 0;
    private static byte ONE = 1;
    private static byte TWO = (byte)2;

    public Version getVersion() {
        return this.version;
    }

    public StreamOutput setVersion(Version version) {
        this.version = version;
        return this;
    }

    public boolean seekPositionSupported() {
        return false;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length());
        bytes.writeTo(this);
    }

    public void writeBytesRef(BytesRef bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length);
        this.write(bytes.bytes, bytes.offset, bytes.length);
    }

    public final void writeShort(short v) throws IOException {
        this.writeByte((byte)(v >> 8));
        this.writeByte((byte)v);
    }

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeVLong(long i) throws IOException {
        assert (i >= 0L);
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(str);
        }
    }

    public void writeOptionalSharedString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeSharedString(str);
        }
    }

    public void writeOptionalText(@Nullable Text text) throws IOException {
        if (text == null) {
            this.writeInt(-1);
        } else {
            this.writeText(text);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes()) {
            String string = text.string();
            UnicodeUtil.UTF16toUTF8(string, 0, string.length(), this.spare);
            this.writeInt(this.spare.length);
            this.write(this.spare.bytes, this.spare.offset, this.spare.length);
        } else {
            BytesReference bytes = text.bytes();
            this.writeInt(bytes.length());
            bytes.writeTo(this);
        }
    }

    public void writeTextArray(Text[] array) throws IOException {
        this.writeVInt(array.length);
        for (Text t : array) {
            this.writeText(t);
        }
    }

    public void writeSharedText(Text text) throws IOException {
        this.writeText(text);
    }

    public void writeString(String str) throws IOException {
        int charCount = str.length();
        this.writeVInt(charCount);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public void writeSharedString(String str) throws IOException {
        this.writeString(str);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    public void writeOptionalBoolean(@Nullable Boolean b) throws IOException {
        if (b == null) {
            this.writeByte(TWO);
        } else {
            this.writeByte(b != false ? ONE : ZERO);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s : array) {
            this.writeString(s);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeVInt(array.length);
            for (String s : array) {
                this.writeString(s);
            }
        }
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeGenericValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.writeByte((byte)0);
            this.writeString((String)value);
        } else if (type == Integer.class) {
            this.writeByte((byte)1);
            this.writeInt((Integer)value);
        } else if (type == Long.class) {
            this.writeByte((byte)2);
            this.writeLong((Long)value);
        } else if (type == Float.class) {
            this.writeByte((byte)3);
            this.writeFloat(((Float)value).floatValue());
        } else if (type == Double.class) {
            this.writeByte((byte)4);
            this.writeDouble((Double)value);
        } else if (type == Boolean.class) {
            this.writeByte((byte)5);
            this.writeBoolean((Boolean)value);
        } else if (type == byte[].class) {
            this.writeByte((byte)6);
            this.writeVInt(((byte[])value).length);
            this.writeBytes((byte[])value);
        } else if (value instanceof List) {
            this.writeByte((byte)7);
            List list = (List)value;
            this.writeVInt(list.size());
            for (Object o : list) {
                this.writeGenericValue(o);
            }
        } else if (value instanceof Object[]) {
            this.writeByte((byte)8);
            Object[] list = (Object[])value;
            this.writeVInt(list.length);
            for (Object o : list) {
                this.writeGenericValue(o);
            }
        } else if (value instanceof Map) {
            if (value instanceof LinkedHashMap) {
                this.writeByte((byte)9);
            } else {
                this.writeByte((byte)10);
            }
            Map map = (Map)value;
            this.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.writeSharedString((String)entry.getKey());
                this.writeGenericValue(entry.getValue());
            }
        } else if (type == Byte.class) {
            this.writeByte((byte)11);
            this.writeByte((Byte)value);
        } else if (type == Date.class) {
            this.writeByte((byte)12);
            this.writeLong(((Date)value).getTime());
        } else if (value instanceof ReadableInstant) {
            this.writeByte((byte)13);
            this.writeLong(((ReadableInstant)value).getMillis());
        } else if (value instanceof BytesReference) {
            this.writeByte((byte)14);
            this.writeBytesReference((BytesReference)value);
        } else if (value instanceof Text) {
            this.writeByte((byte)15);
            this.writeText((Text)value);
        } else if (type == Short.class) {
            this.writeByte((byte)16);
            this.writeShort((Short)value);
        } else if (type == int[].class) {
            this.writeByte((byte)17);
            this.writeIntArray((int[])value);
        } else if (type == long[].class) {
            this.writeByte((byte)18);
            this.writeLongArray((long[])value);
        } else if (type == float[].class) {
            this.writeByte((byte)19);
            this.writeFloatArray((float[])value);
        } else if (type == double[].class) {
            this.writeByte((byte)20);
            this.writeDoubleArray((double[])value);
        } else {
            throw new IOException("Can't write type [" + type + "]");
        }
    }

    public void writeIntArray(int[] value) throws IOException {
        this.writeVInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeInt(value[i]);
        }
    }

    public void writeLongArray(long[] value) throws IOException {
        this.writeVInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeLong(value[i]);
        }
    }

    public void writeFloatArray(float[] value) throws IOException {
        this.writeVInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeFloat(value[i]);
        }
    }

    public void writeDoubleArray(double[] value) throws IOException {
        this.writeVInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeDouble(value[i]);
        }
    }

    public void writeOptionalStreamable(@Nullable Streamable streamable) throws IOException {
        if (streamable != null) {
            this.writeBoolean(true);
            streamable.writeTo(this);
        } else {
            this.writeBoolean(false);
        }
    }
}

