/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.ClusterStateUpdateListener;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataMappingService
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final Object refreshOrUpdateMutex = new Object();
    private final List<MappingTask> refreshOrUpdateQueue = new ArrayList<MappingTask>();
    private long refreshOrUpdateInsertOrder;
    private long refreshOrUpdateProcessedInsertOrder;

    @Inject
    public MetaDataMappingService(Settings settings, ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState executeRefreshOrUpdate(ClusterState currentState, long insertionOrder) throws Exception {
        final ArrayList<MappingTask> allTasks = new ArrayList<MappingTask>();
        Object object = this.refreshOrUpdateMutex;
        synchronized (object) {
            if (this.refreshOrUpdateQueue.isEmpty()) {
                return currentState;
            }
            if (insertionOrder < this.refreshOrUpdateProcessedInsertOrder) {
                return currentState;
            }
            allTasks.addAll(this.refreshOrUpdateQueue);
            this.refreshOrUpdateQueue.clear();
            this.refreshOrUpdateProcessedInsertOrder = this.refreshOrUpdateInsertOrder;
        }
        if (allTasks.isEmpty()) {
            return currentState;
        }
        HashMap tasksPerIndex = Maps.newHashMap();
        for (MappingTask task : allTasks) {
            ArrayList<MappingTask> indexTasks;
            if (task.index == null) {
                this.logger.debug("ignoring a mapping task of type [{}] with a null index.", task);
            }
            if ((indexTasks = (ArrayList<MappingTask>)tasksPerIndex.get(task.index)) == null) {
                indexTasks = new ArrayList<MappingTask>();
                tasksPerIndex.put(task.index, indexTasks);
            }
            indexTasks.add(task);
        }
        boolean dirty = false;
        MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
        for (Map.Entry entry : tasksPerIndex.entrySet()) {
            String index = (String)entry.getKey();
            IndexMetaData indexMetaData = mdBuilder.get(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] ignoring tasks - index meta data doesn't exist", index);
                continue;
            }
            List allIndexTasks = (List)entry.getValue();
            ArrayList<MappingTask> tasks = new ArrayList<MappingTask>();
            for (MappingTask task : allIndexTasks) {
                if (!indexMetaData.isSameUUID(task.indexUUID)) {
                    this.logger.debug("[{}] ignoring task [{}] - index meta data doesn't match task uuid", index, task);
                    continue;
                }
                boolean add = true;
                if (task instanceof UpdateTask) {
                    UpdateTask uTask = (UpdateTask)task;
                    if (uTask.order != -1L && uTask.nodeId != null) {
                        for (int i = 0; i < tasks.size(); ++i) {
                            MappingTask existing = (MappingTask)tasks.get(i);
                            if (!(existing instanceof UpdateTask)) continue;
                            UpdateTask eTask = (UpdateTask)existing;
                            if (!eTask.type.equals(uTask.type) || eTask.order == -1L || eTask.nodeId == null || !eTask.nodeId.equals(uTask.nodeId) || uTask.order <= eTask.order) continue;
                            tasks.set(i, uTask);
                            add = false;
                            break;
                        }
                    }
                }
                if (!add) continue;
                tasks.add(task);
            }
            boolean removeIndex = false;
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                indexService = this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                removeIndex = true;
                HashSet<String> typesToIntroduce = Sets.newHashSet();
                for (MappingTask task : tasks) {
                    if (task instanceof UpdateTask) {
                        typesToIntroduce.add(((UpdateTask)task).type);
                        continue;
                    }
                    if (!(task instanceof RefreshTask)) continue;
                    Collections.addAll(typesToIntroduce, ((RefreshTask)task).types);
                }
                for (String type : typesToIntroduce) {
                    if (!indexMetaData.mappings().containsKey(type)) continue;
                    indexService.mapperService().merge(type, indexMetaData.mappings().get(type).source(), false);
                }
            }
            IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
            try {
                boolean indexDirty = this.processIndexMappingTasks(tasks, indexService, builder);
                if (!indexDirty) continue;
                mdBuilder.put(builder);
                dirty = true;
            }
            finally {
                if (!removeIndex) continue;
                this.indicesService.removeIndex(index, "created for mapping processing");
            }
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                for (Object task : allTasks) {
                    if (!(task instanceof UpdateTask)) continue;
                    UpdateTask uTask = (UpdateTask)task;
                    ClusterStateUpdateResponse response = new ClusterStateUpdateResponse(true);
                    uTask.listener.onResponse(response);
                }
            }
        });
        if (!dirty) {
            return currentState;
        }
        return ClusterState.builder(currentState).metaData(mdBuilder).build();
    }

    private boolean processIndexMappingTasks(List<MappingTask> tasks, IndexService indexService, IndexMetaData.Builder builder) {
        boolean dirty = false;
        String index = indexService.index().name();
        HashSet<String> processedRefreshes = Sets.newHashSet();
        for (MappingTask task : tasks) {
            if (task instanceof RefreshTask) {
                RefreshTask refreshTask = (RefreshTask)task;
                try {
                    ArrayList<String> updatedTypes = Lists.newArrayList();
                    for (String type : refreshTask.types) {
                        DocumentMapper mapper;
                        if (processedRefreshes.contains(type) || (mapper = indexService.mapperService().documentMapper(type)) == null) continue;
                        if (!mapper.mappingSource().equals(builder.mapping(type).source())) {
                            updatedTypes.add(type);
                            builder.putMapping(new MappingMetaData(mapper));
                        }
                        processedRefreshes.add(type);
                    }
                    if (updatedTypes.isEmpty()) continue;
                    this.logger.warn("[{}] re-syncing mappings with cluster state for types [{}]", index, updatedTypes);
                    dirty = true;
                }
                catch (Throwable t) {
                    this.logger.warn("[{}] failed to refresh-mapping in cluster state, types [{}]", index, refreshTask.types);
                }
                continue;
            }
            if (task instanceof UpdateTask) {
                UpdateTask updateTask = (UpdateTask)task;
                try {
                    String type = updateTask.type;
                    CompressedString mappingSource = updateTask.mappingSource;
                    MappingMetaData mappingMetaData = builder.mapping(type);
                    if (mappingMetaData != null && mappingMetaData.source().equals(mappingSource)) {
                        this.logger.debug("[{}] update_mapping [{}] ignoring mapping update task as its source is equal to ours", index, updateTask.type);
                        continue;
                    }
                    DocumentMapper updatedMapper = indexService.mapperService().merge(type, mappingSource, false);
                    processedRefreshes.add(type);
                    if (mappingMetaData != null && mappingMetaData.source().equals(updatedMapper.mappingSource())) {
                        this.logger.debug("[{}] update_mapping [{}] ignoring mapping update task as it results in the same source as what we have", index, updateTask.type);
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}] update_mapping [{}] (dynamic) with source [{}]", index, type, updatedMapper.mappingSource());
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info("[{}] update_mapping [{}] (dynamic)", index, type);
                    }
                    builder.putMapping(new MappingMetaData(updatedMapper));
                    dirty = true;
                }
                catch (Throwable t) {
                    this.logger.warn("[{}] failed to update-mapping in cluster state, type [{}]", index, updateTask.type);
                }
                continue;
            }
            this.logger.warn("illegal state, got wrong mapping task type [{}]", task);
        }
        return dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMapping(String index, String indexUUID, String ... types) {
        long insertOrder;
        Object object = this.refreshOrUpdateMutex;
        synchronized (object) {
            insertOrder = ++this.refreshOrUpdateInsertOrder;
            this.refreshOrUpdateQueue.add(new RefreshTask(index, indexUUID, types));
        }
        this.clusterService.submitStateUpdateTask("refresh-mapping [" + index + "][" + Arrays.toString(types) + "]", Priority.HIGH, new ClusterStateUpdateTask(){

            @Override
            public void onFailure(String source, Throwable t) {
                MetaDataMappingService.this.logger.warn("failure during [{}]", t, source);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetaDataMappingService.this.executeRefreshOrUpdate(currentState, insertOrder);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapping(String index, String indexUUID, String type, CompressedString mappingSource, long order, String nodeId, final ClusterStateUpdateListener listener) {
        long insertOrder;
        Object object = this.refreshOrUpdateMutex;
        synchronized (object) {
            insertOrder = ++this.refreshOrUpdateInsertOrder;
            this.refreshOrUpdateQueue.add(new UpdateTask(index, indexUUID, type, mappingSource, order, nodeId, listener));
        }
        this.clusterService.submitStateUpdateTask("update-mapping [" + index + "][" + type + "] / node [" + nodeId + "], order [" + order + "]", Priority.HIGH, new ClusterStateUpdateTask(){

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetaDataMappingService.this.executeRefreshOrUpdate(currentState, insertOrder);
            }
        });
    }

    public void removeMapping(final DeleteMappingClusterStateUpdateRequest request, final ClusterStateUpdateListener listener) {
        this.clusterService.submitStateUpdateTask("remove-mapping [" + Arrays.toString(request.types()) + "]", Priority.HIGH, new AckedClusterStateUpdateTask(){

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new ClusterStateUpdateResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.indices().length == 0) {
                    throw new IndexMissingException(new Index("_all"));
                }
                MetaData.Builder builder = MetaData.builder(currentState.metaData());
                boolean changed = false;
                String latestIndexWithout = null;
                for (String indexName : request.indices()) {
                    IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                    IndexMetaData.Builder indexBuilder = IndexMetaData.builder(indexMetaData);
                    if (indexMetaData != null) {
                        boolean isLatestIndexWithout = true;
                        for (String type : request.types()) {
                            if (!indexMetaData.mappings().containsKey(type)) continue;
                            indexBuilder.removeMapping(type);
                            changed = true;
                            isLatestIndexWithout = false;
                        }
                        if (isLatestIndexWithout) {
                            latestIndexWithout = indexMetaData.index();
                        }
                    }
                    builder.put(indexBuilder);
                }
                if (!changed) {
                    throw new TypeMissingException(new Index(latestIndexWithout), request.types());
                }
                MetaDataMappingService.this.logger.info("[{}] remove_mapping [{}]", request.indices(), request.types());
                return ClusterState.builder(currentState).metaData(builder).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, final ClusterStateUpdateListener listener) {
        this.clusterService.submitStateUpdateTask("put-mapping [" + request.type() + "]", Priority.HIGH, new AckedClusterStateUpdateTask(){

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new ClusterStateUpdateResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ArrayList<String> indicesToClose = Lists.newArrayList();
                try {
                    DocumentMapper newMapper;
                    for (String index : request.indices()) {
                        if (currentState.metaData().hasIndex(index)) continue;
                        throw new IndexMissingException(new Index(index));
                    }
                    for (String index : request.indices()) {
                        if (MetaDataMappingService.this.indicesService.hasIndex(index)) continue;
                        IndexMetaData indexMetaData = currentState.metaData().index(index);
                        IndexService indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), MetaDataMappingService.this.clusterService.localNode().id());
                        indicesToClose.add(indexMetaData.index());
                        if (indexMetaData.mappings().containsKey("_default_")) {
                            indexService.mapperService().merge("_default_", indexMetaData.mappings().get("_default_").source(), false);
                        }
                        if (!indexMetaData.mappings().containsKey(request.type())) continue;
                        indexService.mapperService().merge(request.type(), indexMetaData.mappings().get(request.type()).source(), false);
                    }
                    HashMap<String, DocumentMapper> newMappers = Maps.newHashMap();
                    HashMap<String, DocumentMapper> existingMappers = Maps.newHashMap();
                    for (String index : request.indices()) {
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                        if (indexService != null) {
                            DocumentMapper existingMapper = indexService.mapperService().documentMapper(request.type());
                            if ("_default_".equals(request.type())) {
                                newMapper = indexService.mapperService().parse(request.type(), new CompressedString(request.source()), false);
                            } else {
                                newMapper = indexService.mapperService().parse(request.type(), new CompressedString(request.source()));
                                if (existingMapper != null) {
                                    DocumentMapper.MergeResult mergeResult = existingMapper.merge(newMapper, DocumentMapper.MergeFlags.mergeFlags().simulate(true));
                                    if (!request.ignoreConflicts() && mergeResult.hasConflicts()) {
                                        throw new MergeMappingException(mergeResult.conflicts());
                                    }
                                }
                            }
                            newMappers.put(index, newMapper);
                            if (existingMapper == null) continue;
                            existingMappers.put(index, existingMapper);
                            continue;
                        }
                        throw new IndexMissingException(new Index(index));
                    }
                    String mappingType = request.type();
                    if (mappingType == null) {
                        mappingType = ((DocumentMapper)newMappers.values().iterator().next()).type();
                    } else if (!mappingType.equals(((DocumentMapper)newMappers.values().iterator().next()).type())) {
                        throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition");
                    }
                    if (!"_default_".equals(mappingType) && !".percolator".equals(mappingType) && mappingType.charAt(0) == '_') {
                        throw new InvalidTypeNameException("Document mapping type name can't start with '_'");
                    }
                    HashMap<String, MappingMetaData> mappings = Maps.newHashMap();
                    for (Map.Entry entry : newMappers.entrySet()) {
                        String index = (String)entry.getKey();
                        newMapper = (DocumentMapper)entry.getValue();
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                        CompressedString existingSource = null;
                        if (existingMappers.containsKey(entry.getKey())) {
                            existingSource = ((DocumentMapper)existingMappers.get(entry.getKey())).mappingSource();
                        }
                        DocumentMapper mergedMapper = indexService.mapperService().merge(newMapper.type(), newMapper.mappingSource(), false);
                        CompressedString updatedSource = mergedMapper.mappingSource();
                        if (existingSource != null) {
                            if (existingSource.equals(updatedSource)) continue;
                            mappings.put(index, new MappingMetaData(mergedMapper));
                            if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                                MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] with source [{}]", index, mergedMapper.type(), updatedSource);
                                continue;
                            }
                            if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                            MetaDataMappingService.this.logger.info("[{}] update_mapping [{}]", index, mergedMapper.type());
                            continue;
                        }
                        mappings.put(index, new MappingMetaData(mergedMapper));
                        if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                            MetaDataMappingService.this.logger.debug("[{}] create_mapping [{}] with source [{}]", index, newMapper.type(), updatedSource);
                            continue;
                        }
                        if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                        MetaDataMappingService.this.logger.info("[{}] create_mapping [{}]", index, newMapper.type());
                    }
                    if (mappings.isEmpty()) {
                        ClusterState i$ = currentState;
                        return i$;
                    }
                    MetaData.Builder builder = MetaData.builder(currentState.metaData());
                    for (String indexName : request.indices()) {
                        IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(indexName));
                        }
                        MappingMetaData mappingMd = (MappingMetaData)mappings.get(indexName);
                        if (mappingMd == null) continue;
                        builder.put(IndexMetaData.builder(indexMetaData).putMapping(mappingMd));
                    }
                    ClusterState clusterState = ClusterState.builder(currentState).metaData(builder).build();
                    return clusterState;
                }
                finally {
                    for (String index : indicesToClose) {
                        MetaDataMappingService.this.indicesService.removeIndex(index, "created for mapping processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }

    static class UpdateTask
    extends MappingTask {
        final String type;
        final CompressedString mappingSource;
        final long order;
        final String nodeId;
        final ClusterStateUpdateListener listener;

        UpdateTask(String index, String indexUUID, String type, CompressedString mappingSource, long order, String nodeId, ClusterStateUpdateListener listener) {
            super(index, indexUUID);
            this.type = type;
            this.mappingSource = mappingSource;
            this.order = order;
            this.nodeId = nodeId;
            this.listener = listener;
        }
    }

    static class RefreshTask
    extends MappingTask {
        final String[] types;

        RefreshTask(String index, String indexUUID, String[] types) {
            super(index, indexUUID);
            this.types = types;
        }
    }

    static class MappingTask {
        final String index;
        final String indexUUID;

        MappingTask(String index, String indexUUID) {
            this.index = index;
            this.indexUUID = indexUUID;
        }
    }
}

