/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.jaspell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.UnsortedInputIterator;
import org.apache.lucene.search.suggest.jaspell.JaspellTernarySearchTrie;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;

public class JaspellLookup
extends Lookup {
    JaspellTernarySearchTrie trie = new JaspellTernarySearchTrie();
    private boolean usePrefix = true;
    private int editDistance = 2;
    private long count = 0L;
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_VALUE = 8;

    @Override
    public void build(InputIterator tfit) throws IOException {
        BytesRef spare;
        if (tfit.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (tfit.getComparator() != null) {
            tfit = new UnsortedInputIterator(tfit);
        }
        if (tfit.hasContexts()) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        this.count = 0L;
        this.trie = new JaspellTernarySearchTrie();
        this.trie.setMatchAlmostDiff(this.editDistance);
        CharsRef charsSpare = new CharsRef();
        while ((spare = tfit.next()) != null) {
            long weight = tfit.weight();
            if (spare.length == 0) continue;
            charsSpare.grow(spare.length);
            UnicodeUtil.UTF8toUTF16(spare.bytes, spare.offset, spare.length, charsSpare);
            this.trie.put(charsSpare.toString(), weight);
        }
    }

    public boolean add(CharSequence key, Object value) {
        this.trie.put(key, value);
        return false;
    }

    public Object get(CharSequence key) {
        return this.trie.get(key);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        int count = onlyMorePopular ? num * 2 : num;
        List<String> list = this.usePrefix ? this.trie.matchPrefix(key, count) : this.trie.matchAlmost(key, count);
        if (list == null || list.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (String s : list) {
                long freq = ((Number)this.trie.get(s)).longValue();
                queue.insertWithOverflow(new Lookup.LookupResult(new CharsRef(s), freq));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                String s = list.get(i);
                long freq = ((Number)this.trie.get(s)).longValue();
                res.add(new Lookup.LookupResult(new CharsRef(s), freq));
            }
        }
        return res;
    }

    private void readRecursively(DataInput in, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        JaspellTernarySearchTrie.TSTNode kid;
        node.splitchar = in.readString().charAt(0);
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.data = in.readLong();
        }
        if ((mask & 1) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[1] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 2) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[2] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 4) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[3] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
    }

    private void writeRecursively(DataOutput out, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        if (node == null) {
            return;
        }
        out.writeString(new String(new char[]{node.splitchar}, 0, 1));
        byte mask = 0;
        if (node.relatives[1] != null) {
            mask = (byte)(mask | 1);
        }
        if (node.relatives[2] != null) {
            mask = (byte)(mask | 2);
        }
        if (node.relatives[3] != null) {
            mask = (byte)(mask | 4);
        }
        if (node.data != null) {
            mask = (byte)(mask | 8);
        }
        out.writeByte(mask);
        if (node.data != null) {
            out.writeLong(((Number)node.data).longValue());
        }
        this.writeRecursively(out, node.relatives[1]);
        this.writeRecursively(out, node.relatives[2]);
        this.writeRecursively(out, node.relatives[3]);
    }

    @Override
    public boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        JaspellTernarySearchTrie.TSTNode root = this.trie.getRoot();
        if (root == null) {
            return false;
        }
        this.writeRecursively(output, root);
        return true;
    }

    @Override
    public boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
        jaspellTernarySearchTrie.getClass();
        JaspellTernarySearchTrie.TSTNode root = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', null);
        this.readRecursively(input, root);
        this.trie.setRoot(root);
        return true;
    }

    @Override
    public long sizeInBytes() {
        return this.trie.sizeInBytes();
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

