/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;

public class PlainTextDictionary
implements Dictionary {
    private BufferedReader in;

    public PlainTextDictionary(File file) throws IOException {
        this.in = new BufferedReader(IOUtils.getDecodingReader(file, StandardCharsets.UTF_8));
    }

    public PlainTextDictionary(InputStream dictFile) {
        this.in = new BufferedReader(IOUtils.getDecodingReader(dictFile, StandardCharsets.UTF_8));
    }

    public PlainTextDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    @Override
    public InputIterator getEntryIterator() throws IOException {
        return new InputIterator.InputIteratorWrapper(new FileIterator());
    }

    final class FileIterator
    implements BytesRefIterator {
        private boolean done = false;
        private final BytesRef spare = new BytesRef();

        FileIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BytesRef next() throws IOException {
            if (this.done) {
                return null;
            }
            boolean success = false;
            try {
                String line = PlainTextDictionary.this.in.readLine();
                if (line != null) {
                    this.spare.copyChars(line);
                    return this.spare;
                }
                this.done = true;
                IOUtils.close(PlainTextDictionary.this.in);
                return null;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(PlainTextDictionary.this.in);
                throw throwable;
            }
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return null;
        }
    }
}

