/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.CommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;

public class ExtendedCommonTermsQuery
extends CommonTermsQuery {
    private final FieldMapper<?> mapper;
    private String lowFreqMinNumShouldMatchSpec;
    private String highFreqMinNumShouldMatchSpec;

    public ExtendedCommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, boolean disableCoord, FieldMapper<?> mapper) {
        super(highFreqOccur, lowFreqOccur, maxTermFrequency, disableCoord);
        this.mapper = mapper;
    }

    @Override
    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.lowFreqMinNumShouldMatchSpec, numOptional);
    }

    protected int calcMinimumNumberShouldMatch(String spec, int numOptional) {
        if (spec == null) {
            return 0;
        }
        return Queries.calculateMinShouldMatch(numOptional, spec);
    }

    @Override
    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.highFreqMinNumShouldMatchSpec, numOptional);
    }

    public void setHighFreqMinimumNumberShouldMatch(String spec) {
        this.highFreqMinNumShouldMatchSpec = spec;
    }

    public String getHighFreqMinimumNumberShouldMatchSpec() {
        return this.highFreqMinNumShouldMatchSpec;
    }

    public void setLowFreqMinimumNumberShouldMatch(String spec) {
        this.lowFreqMinNumShouldMatchSpec = spec;
    }

    public String getLowFreqMinimumNumberShouldMatchSpec() {
        return this.lowFreqMinNumShouldMatchSpec;
    }

    @Override
    protected Query newTermQuery(Term term, TermContext context) {
        if (this.mapper == null) {
            return super.newTermQuery(term, context);
        }
        Query query = this.mapper.queryStringTermQuery(term);
        if (query == null) {
            return super.newTermQuery(term, context);
        }
        return query;
    }
}

