/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsBaseFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsBaseFormat;
import org.apache.lucene.codecs.memory.FSTTermsReader;
import org.apache.lucene.codecs.memory.FSTTermsWriter;
import org.apache.lucene.codecs.pulsing.PulsingPostingsReader;
import org.apache.lucene.codecs.pulsing.PulsingPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public class FSTPulsing41PostingsFormat
extends PostingsFormat {
    private final PostingsBaseFormat wrappedPostingsBaseFormat = new Lucene41PostingsBaseFormat();
    private final int freqCutoff;

    public FSTPulsing41PostingsFormat() {
        this(1);
    }

    public FSTPulsing41PostingsFormat(int freqCutoff) {
        super("FSTPulsing41");
        this.freqCutoff = freqCutoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FSTTermsWriter fSTTermsWriter;
        block3: {
            PostingsWriterBase docsWriter = null;
            PulsingPostingsWriter pulsingWriter = null;
            boolean success = false;
            try {
                docsWriter = this.wrappedPostingsBaseFormat.postingsWriterBase(state);
                pulsingWriter = new PulsingPostingsWriter(state, this.freqCutoff, docsWriter);
                FSTTermsWriter ret = new FSTTermsWriter(state, pulsingWriter);
                success = true;
                fSTTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(docsWriter, pulsingWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(docsWriter, pulsingWriter);
        }
        return fSTTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FSTTermsReader fSTTermsReader;
        block3: {
            PostingsReaderBase docsReader = null;
            PulsingPostingsReader pulsingReader = null;
            boolean success = false;
            try {
                docsReader = this.wrappedPostingsBaseFormat.postingsReaderBase(state);
                pulsingReader = new PulsingPostingsReader(state, docsReader);
                FSTTermsReader ret = new FSTTermsReader(state, pulsingReader);
                success = true;
                fSTTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(docsReader, pulsingReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(docsReader, pulsingReader);
        }
        return fSTTermsReader;
    }
}

