/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

class DirectDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedEntry> sorteds;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BinaryDocValues> binaryInstances;
    private final Map<Integer, SortedDocValues> sortedInstances;
    private final Map<Integer, SortedSetRawValues> sortedSetInstances;
    private final Map<Integer, Bits> docsWithFieldInstances;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final int version;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final int VERSION_START = 0;
    static final int VERSION_CHECKSUM = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block10: {
            ChecksumIndexInput in;
            block9: {
                this.numerics = new HashMap<Integer, NumericEntry>();
                this.binaries = new HashMap<Integer, BinaryEntry>();
                this.sorteds = new HashMap<Integer, SortedEntry>();
                this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.binaryInstances = new HashMap<Integer, BinaryDocValues>();
                this.sortedInstances = new HashMap<Integer, SortedDocValues>();
                this.sortedSetInstances = new HashMap<Integer, SortedSetRawValues>();
                this.docsWithFieldInstances = new HashMap<Integer, Bits>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
                success = false;
                try {
                    this.version = CodecUtil.checkHeader(in, metaCodec, 0, 1);
                    this.readFields(in);
                    if (this.version >= 1) {
                        CodecUtil.checkFooter(in);
                    } else {
                        CodecUtil.checkEOF(in);
                    }
                    success = true;
                    if (!success) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block10;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 1);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.data);
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.offset = meta.readLong();
        entry.count = meta.readInt();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.byteWidth = meta.readByte();
        return entry;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.offset = meta.readLong();
        entry.numBytes = meta.readInt();
        entry.count = meta.readInt();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        return entry;
    }

    private SortedEntry readSortedEntry(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.docToOrd = this.readNumericEntry(meta);
        entry.values = this.readBinaryEntry(meta);
        return entry;
    }

    private SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.docToOrdAddress = this.readNumericEntry(meta);
        entry.ords = this.readNumericEntry(meta);
        entry.values = this.readBinaryEntry(meta);
        return entry;
    }

    private void readFields(IndexInput meta) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(fieldNumber, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(fieldNumber, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                this.sorteds.put(fieldNumber, this.readSortedEntry(meta));
            } else if (fieldType == 3) {
                this.sortedSets.put(fieldNumber, this.readSortedSetEntry(meta));
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.version >= 1) {
            CodecUtil.checksumEntireFile(this.data);
        }
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.number);
        if (instance == null) {
            instance = this.loadNumeric(this.numerics.get(field.number));
            this.numericInstances.put(field.number, instance);
        }
        return instance;
    }

    private NumericDocValues loadNumeric(NumericEntry entry) throws IOException {
        this.data.seek(entry.offset + entry.missingBytes);
        switch (entry.byteWidth) {
            case 1: {
                final byte[] values = new byte[entry.count];
                this.data.readBytes(values, 0, entry.count);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(values));
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
            case 2: {
                final short[] values = new short[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readShort();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(values));
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
            case 4: {
                final int[] values = new int[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readInt();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(values));
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
            case 8: {
                final long[] values = new long[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readLong();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(values));
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field.number);
        if (instance == null) {
            instance = this.loadBinary(this.binaries.get(field.number));
            this.binaryInstances.put(field.number, instance);
        }
        return instance;
    }

    private BinaryDocValues loadBinary(BinaryEntry entry) throws IOException {
        this.data.seek(entry.offset);
        final byte[] bytes = new byte[entry.numBytes];
        this.data.readBytes(bytes, 0, entry.numBytes);
        this.data.seek(entry.offset + (long)entry.numBytes + entry.missingBytes);
        final int[] address = new int[entry.count + 1];
        for (int i = 0; i < entry.count; ++i) {
            address[i] = this.data.readInt();
        }
        address[entry.count] = this.data.readInt();
        this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(bytes) + RamUsageEstimator.sizeOf(address));
        return new BinaryDocValues(){

            @Override
            public void get(int docID, BytesRef result) {
                result.bytes = bytes;
                result.offset = address[docID];
                result.length = address[docID + 1] - result.offset;
            }
        };
    }

    @Override
    public synchronized SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedDocValues instance = this.sortedInstances.get(field.number);
        if (instance == null) {
            instance = this.loadSorted(field);
            this.sortedInstances.put(field.number, instance);
        }
        return instance;
    }

    private SortedDocValues loadSorted(FieldInfo field) throws IOException {
        final SortedEntry entry = this.sorteds.get(field.number);
        final NumericDocValues docToOrd = this.loadNumeric(entry.docToOrd);
        final BinaryDocValues values = this.loadBinary(entry.values);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result) {
                values.get(ord, result);
            }

            @Override
            public int getValueCount() {
                return entry.values.count;
            }
        };
    }

    @Override
    public synchronized SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetRawValues instance = this.sortedSetInstances.get(field.number);
        final SortedSetEntry entry = this.sortedSets.get(field.number);
        if (instance == null) {
            instance = this.loadSortedSet(entry);
            this.sortedSetInstances.put(field.number, instance);
        }
        final NumericDocValues docToOrdAddress = instance.docToOrdAddress;
        final NumericDocValues ords = instance.ords;
        final BinaryDocValues values = instance.values;
        return new RandomAccessOrds(){
            int ordStart;
            int ordUpto;
            int ordLimit;

            @Override
            public long nextOrd() {
                if (this.ordUpto == this.ordLimit) {
                    return -1L;
                }
                return ords.get(this.ordUpto++);
            }

            @Override
            public void setDocument(int docID) {
                this.ordStart = this.ordUpto = (int)docToOrdAddress.get(docID);
                this.ordLimit = (int)docToOrdAddress.get(docID + 1);
            }

            @Override
            public void lookupOrd(long ord, BytesRef result) {
                values.get((int)ord, result);
            }

            @Override
            public long getValueCount() {
                return entry.values.count;
            }

            @Override
            public long ordAt(int index) {
                return ords.get(this.ordStart + index);
            }

            @Override
            public int cardinality() {
                return this.ordLimit - this.ordStart;
            }
        };
    }

    private SortedSetRawValues loadSortedSet(SortedSetEntry entry) throws IOException {
        SortedSetRawValues instance = new SortedSetRawValues();
        instance.docToOrdAddress = this.loadNumeric(entry.docToOrdAddress);
        instance.ords = this.loadNumeric(entry.ords);
        instance.values = this.loadBinary(entry.values);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(int fieldNumber, long offset, long length) throws IOException {
        Bits instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        DirectDocValuesProducer directDocValuesProducer = this;
        synchronized (directDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(fieldNumber);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length % 8L == 0L);
                long[] bits = new long[(int)length >> 3];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = data.readLong();
                }
                instance = new FixedBitSet(bits, this.maxDoc);
                this.docsWithFieldInstances.put(fieldNumber, instance);
            }
        }
        return instance;
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(field.number, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(field.number, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class SortedSetEntry {
        NumericEntry docToOrdAddress;
        NumericEntry ords;
        BinaryEntry values;

        SortedSetEntry() {
        }
    }

    static class SortedEntry {
        NumericEntry docToOrd;
        BinaryEntry values;

        SortedEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        int count;
        int numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        int count;
        long missingOffset;
        long missingBytes;
        byte byteWidth;
        int packedIntsVersion;

        NumericEntry() {
        }
    }

    static class SortedSetRawValues {
        NumericDocValues docToOrdAddress;
        NumericDocValues ords;
        BinaryDocValues values;

        SortedSetRawValues() {
        }
    }
}

