/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.impl;

import io.fabric8.insight.elasticsearch.ElasticRest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ElasticSearchServlet
extends HttpServlet {
    private ElasticRest rest;

    public ElasticSearchServlet(ElasticRest rest) {
        this.rest = rest;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        String uri = req.getPathInfo() != null ? req.getPathInfo() : "/";
        String content = ElasticSearchServlet.loadFully((InputStream)req.getInputStream(), req.getCharacterEncoding());
        try {
            String result;
            if ("GET".equals(method)) {
                result = this.rest.get(uri);
            } else if ("POST".equals(method)) {
                result = this.rest.post(uri, content);
            } else if ("PUT".equals(method)) {
                result = this.rest.put(uri, content);
            } else if ("DELETE".equals(method)) {
                result = this.rest.delete(uri);
            } else if ("HEAD".equals(method)) {
                result = this.rest.head(uri);
            } else {
                resp.sendError(501, "Unknown method " + method);
                return;
            }
            resp.getWriter().write(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.rest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFully(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int l;
            while ((l = is.read(buf)) >= 0) {
                baos.write(buf, 0, l);
            }
        }
        finally {
            is.close();
        }
        return encoding != null ? baos.toString(encoding) : baos.toString();
    }
}

