/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.impl;

import io.fabric8.insight.elasticsearch.impl.ElasticRestMBean;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.node.internal.InternalNode;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.support.RestUtils;

public class ElasticRest
implements ElasticRestMBean {
    private InternalNode node;
    private RestController controller;

    public ElasticRest() {
    }

    public ElasticRest(InternalNode node) {
        this.setNode(node);
    }

    public void setNode(InternalNode node) {
        this.node = node;
        this.controller = node.injector().getInstance(RestController.class);
    }

    public String get(String uri) throws IOException {
        return this.exec("GET", uri, null);
    }

    public String post(String uri, String content) throws IOException {
        return this.exec("POST", uri, content);
    }

    public String put(String uri, String content) throws IOException {
        return this.exec("PUT", uri, content);
    }

    public String delete(String uri) throws IOException {
        return this.exec("DELETE", uri, null);
    }

    public String head(String uri) throws IOException {
        return this.exec("HEAD", uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exec(String method, String resource, String content) throws IOException {
        Channel channel;
        Request request = new Request(method, resource, content);
        Channel channel2 = channel = new Channel(request);
        synchronized (channel2) {
            this.controller.dispatchRequest(new Request(method, resource, content), channel);
            if (channel.getResponse() == null) {
                try {
                    channel.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
            String result = channel.getResponse().content().toUtf8();
            if (channel.getResponse().status().getStatus() >= 400) {
                throw new IOException(result);
            }
            return result;
        }
    }

    static class Channel
    extends RestChannel {
        private RestResponse response;

        Channel(RestRequest request) {
            super(request);
        }

        @Override
        public synchronized void sendResponse(RestResponse response) {
            if (response.status() != RestStatus.CONTINUE) {
                this.response = response;
                this.notifyAll();
            }
        }

        public RestResponse getResponse() {
            return this.response;
        }
    }

    static class Request
    extends RestRequest {
        private final String method;
        private final String uri;
        private final Map<String, String> params;
        private final String rawPath;
        private final byte[] rawContent;

        Request(String method, String uri, String content) {
            this.method = method;
            this.uri = uri == null ? "" : uri;
            this.params = new HashMap<String, String>();
            int pathEndPos = uri.indexOf(63);
            if (pathEndPos < 0) {
                this.rawPath = uri;
            } else {
                this.rawPath = uri.substring(0, pathEndPos);
                RestUtils.decodeQueryString(uri, pathEndPos + 1, this.params);
            }
            this.rawContent = content != null ? content.getBytes() : null;
        }

        @Override
        public RestRequest.Method method() {
            return RestRequest.Method.valueOf(this.method.toUpperCase());
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String rawPath() {
            return this.rawPath;
        }

        @Override
        public boolean hasContent() {
            return this.rawContent != null;
        }

        @Override
        public boolean contentUnsafe() {
            return false;
        }

        @Override
        public BytesReference content() {
            return new BytesArray(this.rawContent);
        }

        @Override
        public Iterable<Map.Entry<String, String>> headers() {
            return Collections.emptyMap().entrySet();
        }

        @Override
        public String header(String name) {
            return null;
        }

        @Override
        public boolean hasParam(String key) {
            return this.params.containsKey(key);
        }

        @Override
        public String param(String key) {
            return this.params.get(key);
        }

        @Override
        public Map<String, String> params() {
            return this.params;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (this.params.containsKey(key)) {
                return this.params.get(key);
            }
            return defaultValue;
        }
    }
}

