/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.command;

import io.fabric8.insight.elasticsearch.ElasticRest;
import java.io.IOException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="elasticsearch", name="esrest")
public class EsRest
extends OsgiCommandSupport {
    @Option(name="--no-pretty")
    boolean noPretty = false;
    @Option(name="--get")
    boolean get;
    @Option(name="--put")
    boolean put;
    @Option(name="--delete")
    boolean delete;
    @Option(name="--head")
    boolean head;
    @Option(name="--post")
    boolean post;
    @Argument(required=true)
    String uri;
    @Argument(index=1)
    String body;

    protected Object doExecute() throws Exception {
        ElasticRest rest = (ElasticRest)this.getService(ElasticRest.class);
        if (rest == null) {
            throw new IllegalStateException("Unable to find ElasticSearch");
        }
        this.doExecute(rest);
        return null;
    }

    protected void doExecute(ElasticRest rest) throws IOException {
        int nb = (this.get ? 1 : 0) + (this.put ? 1 : 0) + (this.delete ? 1 : 0) + (this.head ? 1 : 0) + (this.post ? 1 : 0);
        if (nb > 1) {
            throw new IllegalArgumentException("Only one of get / put / delete / head / post can be used");
        }
        if (!this.noPretty) {
            int idx = this.uri.indexOf("?");
            if (idx > 0) {
                boolean hasPretty = false;
                for (String p : this.uri.substring(idx + 1).split("&")) {
                    hasPretty |= p.equals("pretty") || p.startsWith("pretty=");
                }
                this.uri = this.uri + "&pretty";
            } else {
                this.uri = this.uri + "?pretty";
            }
        }
        String ret = this.post ? rest.post(this.uri, this.body != null ? this.body : "") : (this.put ? rest.put(this.uri, this.body != null ? this.body : "") : (this.head ? rest.head(this.uri) : (this.delete ? rest.delete(this.uri) : rest.get(this.uri))));
        System.out.println(ret);
    }
}

