/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum SnapshotState {
    IN_PROGRESS(0, false, false),
    SUCCESS(1, true, true),
    FAILED(2, true, false),
    PARTIAL(3, true, true);

    private byte value;
    private boolean completed;
    private boolean restorable;

    private SnapshotState(byte value, boolean completed, boolean restorable) {
        this.value = value;
        this.completed = completed;
        this.restorable = restorable;
    }

    public byte value() {
        return this.value;
    }

    public boolean completed() {
        return this.completed;
    }

    public boolean restorable() {
        return this.restorable;
    }

    public static SnapshotState fromValue(byte value) {
        switch (value) {
            case 0: {
                return IN_PROGRESS;
            }
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return FAILED;
            }
            case 3: {
                return PARTIAL;
            }
        }
        throw new ElasticsearchIllegalArgumentException("No snapshot state for value [" + value + "]");
    }
}

