/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.longs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.longs.InternalTermsStatsLongFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsLongFacetExecutor
extends FacetExecutor {
    private final TermsStatsFacet.ComparatorType comparatorType;
    final IndexNumericFieldData keyIndexFieldData;
    final IndexNumericFieldData valueIndexFieldData;
    final SearchScript script;
    private final int size;
    private final int shardSize;
    final Recycler.V<LongObjectOpenHashMap<InternalTermsStatsLongFacet.LongEntry>> entries;
    long missing;

    public TermsStatsLongFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, SearchScript script, int size, int shardSize, TermsStatsFacet.ComparatorType comparatorType, SearchContext context) {
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.script = script;
        this.entries = context.cacheRecycler().longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        InternalTermsStatsLongFacet.LongEntry value;
        if (this.entries.v().isEmpty()) {
            this.entries.close();
            return new InternalTermsStatsLongFacet(facetName, this.comparatorType, this.size, ImmutableList.of(), this.missing);
        }
        if (this.size == 0) {
            ArrayList<InternalTermsStatsLongFacet.LongEntry> longEntries = new ArrayList<InternalTermsStatsLongFacet.LongEntry>(this.entries.v().size());
            boolean[] states = this.entries.v().allocated;
            VType[] values = this.entries.v().values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                longEntries.add((InternalTermsStatsLongFacet.LongEntry)values[i]);
            }
            this.entries.close();
            return new InternalTermsStatsLongFacet(facetName, this.comparatorType, 0, longEntries, this.missing);
        }
        VType[] values = this.entries.v().values;
        Arrays.sort(values, this.comparatorType.comparator());
        int limit = this.shardSize;
        ArrayList<InternalTermsStatsLongFacet.LongEntry> ordered = Lists.newArrayList();
        for (int i = 0; i < limit && (value = (InternalTermsStatsLongFacet.LongEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        this.entries.close();
        return new InternalTermsStatsLongFacet(facetName, this.comparatorType, this.size, ordered, this.missing);
    }

    public static class ScriptAggregator
    extends Aggregator {
        private final SearchScript script;

        public ScriptAggregator(LongObjectOpenHashMap<InternalTermsStatsLongFacet.LongEntry> entries, SearchScript script) {
            super(entries);
            this.script = script;
        }

        @Override
        public void onValue(int docId, long value) {
            InternalTermsStatsLongFacet.LongEntry longEntry = (InternalTermsStatsLongFacet.LongEntry)this.entries.get(value);
            if (longEntry == null) {
                longEntry = new InternalTermsStatsLongFacet.LongEntry(value, 1L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value, longEntry);
            } else {
                ++longEntry.count;
            }
            this.script.setNextDocId(docId);
            double valueValue = this.script.runAsDouble();
            if (valueValue < longEntry.min) {
                longEntry.min = valueValue;
            }
            if (valueValue > longEntry.max) {
                longEntry.max = valueValue;
            }
            ++longEntry.totalCount;
            longEntry.total += valueValue;
        }
    }

    public static class Aggregator
    extends LongFacetAggregatorBase {
        final LongObjectOpenHashMap<InternalTermsStatsLongFacet.LongEntry> entries;
        DoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public Aggregator(LongObjectOpenHashMap<InternalTermsStatsLongFacet.LongEntry> entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, long value) {
            InternalTermsStatsLongFacet.LongEntry longEntry = this.entries.get(value);
            if (longEntry == null) {
                longEntry = new InternalTermsStatsLongFacet.LongEntry(value, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value, longEntry);
            }
            ++longEntry.count;
            this.valueAggregator.longEntry = longEntry;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalTermsStatsLongFacet.LongEntry longEntry;

            @Override
            public void onValue(int docId, double value) {
                if (value < this.longEntry.min) {
                    this.longEntry.min = value;
                }
                if (value > this.longEntry.max) {
                    this.longEntry.max = value;
                }
                this.longEntry.total += value;
                ++this.longEntry.totalCount;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final Aggregator aggregator;
        private LongValues keyValues;

        public Collector() {
            this.aggregator = TermsStatsLongFacetExecutor.this.script == null ? new Aggregator(TermsStatsLongFacetExecutor.this.entries.v()) : new ScriptAggregator(TermsStatsLongFacetExecutor.this.entries.v(), TermsStatsLongFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsStatsLongFacetExecutor.this.script != null) {
                TermsStatsLongFacetExecutor.this.script.setScorer(scorer);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = TermsStatsLongFacetExecutor.this.keyIndexFieldData.load(context).getLongValues();
            if (TermsStatsLongFacetExecutor.this.script != null) {
                TermsStatsLongFacetExecutor.this.script.setNextReader(context);
            } else {
                this.aggregator.valueValues = TermsStatsLongFacetExecutor.this.valueIndexFieldData.load(context).getDoubleValues();
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
            TermsStatsLongFacetExecutor.this.missing = this.aggregator.missing();
        }
    }
}

