/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class RangeFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final RangeFacet.Entry[] entries;

    public RangeFacetExecutor(IndexNumericFieldData indexFieldData, RangeFacet.Entry[] entries, SearchContext context) {
        this.indexFieldData = indexFieldData;
        this.entries = entries;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalRangeFacet(facetName, this.entries);
    }

    public static class RangeProc
    extends DoubleFacetAggregatorBase {
        private final RangeFacet.Entry[] entries;

        public RangeProc(RangeFacet.Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value) {
            for (RangeFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(value >= entry.getFrom()) || !(value < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                ++entry.totalCount;
                entry.total += value;
                if (value < entry.min) {
                    entry.min = value;
                }
                if (!(value > entry.max)) continue;
                entry.max = value;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final RangeProc rangeProc;
        private DoubleValues values;

        public Collector() {
            this.rangeProc = new RangeProc(RangeFacetExecutor.this.entries);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = RangeFacetExecutor.this.indexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            for (RangeFacet.Entry entry : RangeFacetExecutor.this.entries) {
                entry.foundInDoc = false;
            }
            this.rangeProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

