/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.min;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalMin
extends MetricsAggregation.SingleValue
implements Min {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("min");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalMin readResult(StreamInput in) throws IOException {
            InternalMin result = new InternalMin();
            result.readFrom(in);
            return result;
        }
    };
    private double min;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalMin() {
    }

    public InternalMin(String name, double min) {
        super(name);
        this.min = min;
    }

    @Override
    public double value() {
        return this.min;
    }

    @Override
    public double getValue() {
        return this.min;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalMin reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            return (InternalMin)aggregations.get(0);
        }
        InternalMin reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            if (reduced == null) {
                reduced = (InternalMin)aggregation;
                continue;
            }
            reduced.min = Math.min(reduced.min, ((InternalMin)aggregation).min);
        }
        if (reduced != null) {
            return reduced;
        }
        return (InternalMin)aggregations.get(0);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.min = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.min);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        boolean hasValue = !Double.isInfinite(this.min);
        builder.field(InternalAggregation.CommonFields.VALUE, hasValue ? Double.valueOf(this.min) : null);
        if (hasValue && this.valueFormatter != null) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.min));
        }
        builder.endObject();
        return builder;
    }
}

