/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class MissingFilterParser
implements FilterParser {
    public static final String NAME = "missing";
    public static final boolean DEFAULT_NULL_VALUE = false;
    public static final boolean DEFAULT_EXISTENCE_VALUE = true;

    @Inject
    public MissingFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldPattern = null;
        String filterName = null;
        boolean nullValue = false;
        boolean existence = true;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                fieldPattern = parser.text();
                continue;
            }
            if ("null_value".equals(currentFieldName)) {
                nullValue = parser.booleanValue();
                continue;
            }
            if ("existence".equals(currentFieldName)) {
                existence = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[missing] filter does not support [" + currentFieldName + "]");
        }
        if (fieldPattern == null) {
            throw new QueryParsingException(parseContext.index(), "missing must be provided with a [field]");
        }
        return MissingFilterParser.newFilter(parseContext, fieldPattern, existence, nullValue, filterName);
    }

    public static Filter newFilter(QueryParseContext parseContext, String fieldPattern, boolean existence, boolean nullValue, String filterName) {
        Filter filter;
        Set<String> fields;
        if (!existence && !nullValue) {
            throw new QueryParsingException(parseContext.index(), "missing must have either existence, or null_value, or both set to true");
        }
        MapperService.SmartNameObjectMapper smartNameObjectMapper = parseContext.smartObjectMapper(fieldPattern);
        if (smartNameObjectMapper != null && smartNameObjectMapper.hasMapper()) {
            fieldPattern = fieldPattern + ".*";
        }
        if ((fields = parseContext.simpleMatchToIndexNames(fieldPattern)).isEmpty()) {
            if (existence) {
                return Queries.MATCH_ALL_FILTER;
            }
            return null;
        }
        Filter existenceFilter = null;
        Filter nullFilter = null;
        MapperService.SmartNameFieldMappers nonNullFieldMappers = null;
        if (existence) {
            XBooleanFilter boolFilter = new XBooleanFilter();
            for (String field : fields) {
                MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(field);
                if (smartNameFieldMappers != null) {
                    nonNullFieldMappers = smartNameFieldMappers;
                }
                Filter filter2 = null;
                if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                    filter2 = smartNameFieldMappers.mapper().rangeFilter(null, null, true, true, parseContext);
                }
                if (filter2 == null) {
                    filter2 = new TermRangeFilter(field, null, null, true, true);
                }
                boolFilter.add(filter2, BooleanClause.Occur.SHOULD);
            }
            existenceFilter = parseContext.cacheFilter(boolFilter, new CacheKeyFilter.Key("$exists$" + fieldPattern));
            existenceFilter = new NotFilter(existenceFilter);
            existenceFilter = parseContext.cacheFilter(existenceFilter, new CacheKeyFilter.Key("$missing$" + fieldPattern));
        }
        if (nullValue) {
            for (String field : fields) {
                MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(field);
                if (smartNameFieldMappers == null || !smartNameFieldMappers.hasMapper() || (nullFilter = smartNameFieldMappers.mapper().nullValueFilter()) == null) continue;
                nullFilter = parseContext.cacheFilter(nullFilter, new CacheKeyFilter.Key("$null$" + fieldPattern));
            }
        }
        if (nullFilter != null) {
            if (existenceFilter != null) {
                XBooleanFilter combined = new XBooleanFilter();
                combined.add(existenceFilter, BooleanClause.Occur.SHOULD);
                combined.add(nullFilter, BooleanClause.Occur.SHOULD);
                filter = parseContext.cacheFilter(combined, null);
            } else {
                filter = nullFilter;
            }
        } else {
            filter = existenceFilter;
        }
        if (filter == null) {
            return null;
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, nonNullFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, existenceFilter);
        }
        return filter;
    }
}

