/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.LogDocMergePolicy;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.policy.AbstractMergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.Store;

public class LogDocMergePolicyProvider
extends AbstractMergePolicyProvider<LogDocMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    public static final String MAX_MERGE_DOCS_KEY = "index.merge.policy.max_merge_docs";
    public static final String MIN_MERGE_DOCS_KEY = "index.merge.policy.min_merge_docs";
    public static final String MERGE_FACTORY_KEY = "index.merge.policy.merge_factor";
    private volatile int minMergeDocs;
    private volatile int maxMergeDocs;
    private volatile int mergeFactor;
    private final boolean calibrateSizeByDeletes;
    private final Set<CustomLogDocMergePolicy> policies = new CopyOnWriteArraySet<CustomLogDocMergePolicy>();
    private final ApplySettings applySettings = new ApplySettings();
    public static final String INDEX_MERGE_POLICY_MIN_MERGE_DOCS = "index.merge.policy.min_merge_docs";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_DOCS = "index.merge.policy.max_merge_docs";
    public static final String INDEX_MERGE_POLICY_MERGE_FACTOR = "index.merge.policy.merge_factor";

    @Inject
    public LogDocMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store);
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.indexSettingsService = indexSettingsService;
        this.minMergeDocs = this.componentSettings.getAsInt("min_merge_docs", (Integer)1000);
        this.maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", (Integer)Integer.MAX_VALUE);
        this.mergeFactor = this.componentSettings.getAsInt("merge_factor", (Integer)10);
        this.calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", (Boolean)true);
        this.logger.debug("using [log_doc] merge policy with merge_factor[{}], min_merge_docs[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}]", this.mergeFactor, this.minMergeDocs, this.maxMergeDocs, this.calibrateSizeByDeletes);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    @Override
    public LogDocMergePolicy newMergePolicy() {
        CustomLogDocMergePolicy mergePolicy = new CustomLogDocMergePolicy(this);
        mergePolicy.setMinMergeDocs(this.minMergeDocs);
        mergePolicy.setMaxMergeDocs(this.maxMergeDocs);
        mergePolicy.setMergeFactor(this.mergeFactor);
        mergePolicy.setCalibrateSizeByDeletes(this.calibrateSizeByDeletes);
        mergePolicy.setNoCFSRatio(this.noCFSRatio);
        this.policies.add(mergePolicy);
        return mergePolicy;
    }

    public static class CustomLogDocMergePolicy
    extends LogDocMergePolicy {
        private final LogDocMergePolicyProvider provider;

        public CustomLogDocMergePolicy(LogDocMergePolicyProvider provider) {
            this.provider = provider;
        }

        @Override
        public void close() {
            super.close();
            this.provider.policies.remove(this);
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double noCFSRatio;
            boolean compoundFormat;
            int mergeFactor;
            int maxMergeDocs;
            int minMergeDocs = settings.getAsInt("index.merge.policy.min_merge_docs", (Integer)LogDocMergePolicyProvider.this.minMergeDocs);
            if (minMergeDocs != LogDocMergePolicyProvider.this.minMergeDocs) {
                LogDocMergePolicyProvider.this.logger.info("updating min_merge_docs from [{}] to [{}]", LogDocMergePolicyProvider.this.minMergeDocs, minMergeDocs);
                LogDocMergePolicyProvider.this.minMergeDocs = minMergeDocs;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setMinMergeDocs(minMergeDocs);
                }
            }
            if ((maxMergeDocs = settings.getAsInt("index.merge.policy.max_merge_docs", (Integer)LogDocMergePolicyProvider.this.maxMergeDocs).intValue()) != LogDocMergePolicyProvider.this.maxMergeDocs) {
                LogDocMergePolicyProvider.this.logger.info("updating max_merge_docs from [{}] to [{}]", LogDocMergePolicyProvider.this.maxMergeDocs, maxMergeDocs);
                LogDocMergePolicyProvider.this.maxMergeDocs = maxMergeDocs;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setMaxMergeDocs(maxMergeDocs);
                }
            }
            if ((mergeFactor = settings.getAsInt("index.merge.policy.merge_factor", (Integer)LogDocMergePolicyProvider.this.mergeFactor).intValue()) != LogDocMergePolicyProvider.this.mergeFactor) {
                LogDocMergePolicyProvider.this.logger.info("updating merge_factor from [{}] to [{}]", LogDocMergePolicyProvider.this.mergeFactor, mergeFactor);
                LogDocMergePolicyProvider.this.mergeFactor = mergeFactor;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setMergeFactor(mergeFactor);
                }
            }
            boolean bl = compoundFormat = (noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(settings.get("index.compound_format", Double.toString(LogDocMergePolicyProvider.this.noCFSRatio)))) != 0.0;
            if (noCFSRatio != LogDocMergePolicyProvider.this.noCFSRatio) {
                LogDocMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", AbstractMergePolicyProvider.formatNoCFSRatio(LogDocMergePolicyProvider.this.noCFSRatio), AbstractMergePolicyProvider.formatNoCFSRatio(noCFSRatio));
                LogDocMergePolicyProvider.this.noCFSRatio = noCFSRatio;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setNoCFSRatio(noCFSRatio);
                }
            }
        }
    }
}

