/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.AbstractMergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.Store;

public class LogByteSizeMergePolicyProvider
extends AbstractMergePolicyProvider<LogByteSizeMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    public static final String MAX_MERGE_BYTE_SIZE_KEY = "index.merge.policy.max_merge_sizes";
    public static final String MIN_MERGE_BYTE_SIZE_KEY = "index.merge.policy.min_merge_size";
    public static final String MERGE_FACTORY_KEY = "index.merge.policy.merge_factor";
    private volatile ByteSizeValue minMergeSize;
    private volatile ByteSizeValue maxMergeSize;
    private volatile int mergeFactor;
    private volatile int maxMergeDocs;
    private final boolean calibrateSizeByDeletes;
    private final Set<CustomLogByteSizeMergePolicy> policies = new CopyOnWriteArraySet<CustomLogByteSizeMergePolicy>();
    private final ApplySettings applySettings = new ApplySettings();
    public static final String INDEX_MERGE_POLICY_MIN_MERGE_SIZE = "index.merge.policy.min_merge_size";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_SIZE = "index.merge.policy.max_merge_size";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_DOCS = "index.merge.policy.max_merge_docs";
    public static final String INDEX_MERGE_POLICY_MERGE_FACTOR = "index.merge.policy.merge_factor";

    @Inject
    public LogByteSizeMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store);
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.indexSettingsService = indexSettingsService;
        this.minMergeSize = this.componentSettings.getAsBytesSize("min_merge_size", new ByteSizeValue(0x199999L, ByteSizeUnit.BYTES));
        this.maxMergeSize = this.componentSettings.getAsBytesSize("max_merge_size", new ByteSizeValue(2048L, ByteSizeUnit.MB));
        this.mergeFactor = this.componentSettings.getAsInt("merge_factor", (Integer)10);
        this.maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", (Integer)Integer.MAX_VALUE);
        this.calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", (Boolean)true);
        this.logger.debug("using [log_bytes_size] merge policy with merge_factor[{}], min_merge_size[{}], max_merge_size[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}]", this.mergeFactor, this.minMergeSize, this.maxMergeSize, this.maxMergeDocs, this.calibrateSizeByDeletes);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public LogByteSizeMergePolicy newMergePolicy() {
        CustomLogByteSizeMergePolicy mergePolicy = new CustomLogByteSizeMergePolicy(this);
        mergePolicy.setMinMergeMB(this.minMergeSize.mbFrac());
        mergePolicy.setMaxMergeMB(this.maxMergeSize.mbFrac());
        mergePolicy.setMergeFactor(this.mergeFactor);
        mergePolicy.setMaxMergeDocs(this.maxMergeDocs);
        mergePolicy.setCalibrateSizeByDeletes(this.calibrateSizeByDeletes);
        mergePolicy.setNoCFSRatio(this.noCFSRatio);
        this.policies.add(mergePolicy);
        return mergePolicy;
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    public static class CustomLogByteSizeMergePolicy
    extends LogByteSizeMergePolicy {
        private final LogByteSizeMergePolicyProvider provider;

        public CustomLogByteSizeMergePolicy(LogByteSizeMergePolicyProvider provider) {
            this.provider = provider;
        }

        @Override
        public void close() {
            super.close();
            this.provider.policies.remove(this);
        }

        @Override
        public MergePolicy clone() {
            return this;
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double noCFSRatio;
            int mergeFactor;
            int maxMergeDocs;
            ByteSizeValue maxMergeSize;
            ByteSizeValue minMergeSize = settings.getAsBytesSize("index.merge.policy.min_merge_size", LogByteSizeMergePolicyProvider.this.minMergeSize);
            if (!minMergeSize.equals(LogByteSizeMergePolicyProvider.this.minMergeSize)) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating min_merge_size from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.minMergeSize, minMergeSize);
                LogByteSizeMergePolicyProvider.this.minMergeSize = minMergeSize;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMinMergeMB(minMergeSize.mbFrac());
                }
            }
            if (!(maxMergeSize = settings.getAsBytesSize(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_SIZE, LogByteSizeMergePolicyProvider.this.maxMergeSize)).equals(LogByteSizeMergePolicyProvider.this.maxMergeSize)) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating max_merge_size from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.maxMergeSize, maxMergeSize);
                LogByteSizeMergePolicyProvider.this.maxMergeSize = maxMergeSize;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMaxMergeMB(maxMergeSize.mbFrac());
                }
            }
            if ((maxMergeDocs = settings.getAsInt(LogByteSizeMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_DOCS, (Integer)LogByteSizeMergePolicyProvider.this.maxMergeDocs).intValue()) != LogByteSizeMergePolicyProvider.this.maxMergeDocs) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating max_merge_docs from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.maxMergeDocs, maxMergeDocs);
                LogByteSizeMergePolicyProvider.this.maxMergeDocs = maxMergeDocs;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMaxMergeDocs(maxMergeDocs);
                }
            }
            if ((mergeFactor = settings.getAsInt("index.merge.policy.merge_factor", (Integer)LogByteSizeMergePolicyProvider.this.mergeFactor).intValue()) != LogByteSizeMergePolicyProvider.this.mergeFactor) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating merge_factor from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.mergeFactor, mergeFactor);
                LogByteSizeMergePolicyProvider.this.mergeFactor = mergeFactor;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMergeFactor(mergeFactor);
                }
            }
            if ((noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(settings.get("index.compound_format", Double.toString(LogByteSizeMergePolicyProvider.this.noCFSRatio)))) != LogByteSizeMergePolicyProvider.this.noCFSRatio) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", AbstractMergePolicyProvider.formatNoCFSRatio(LogByteSizeMergePolicyProvider.this.noCFSRatio), AbstractMergePolicyProvider.formatNoCFSRatio(noCFSRatio));
                LogByteSizeMergePolicyProvider.this.noCFSRatio = noCFSRatio;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setNoCFSRatio(noCFSRatio);
                }
            }
        }
    }
}

