/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AtomicFieldDataWithOrdinalsTermsEnum;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class IndexIndexFieldData
implements IndexFieldData.WithOrdinals<AtomicFieldData.WithOrdinals<ScriptDocValues>> {
    private static final Ordinals.Docs INDEX_ORDINALS = new Ordinals.Docs(){

        @Override
        public int setDocument(int docId) {
            return 1;
        }

        @Override
        public long nextOrd() {
            return 0L;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public long getOrd(int docId) {
            return 0L;
        }

        @Override
        public long getMaxOrd() {
            return 1L;
        }

        @Override
        public long currentOrd() {
            return 0L;
        }
    };
    private final FieldMapper.Names names;
    private final Index index;

    private IndexIndexFieldData(Index index, FieldMapper.Names names) {
        this.index = index;
        this.names = names;
    }

    @Override
    public Index index() {
        return this.index;
    }

    @Override
    public FieldMapper.Names getFieldNames() {
        return this.names;
    }

    @Override
    public FieldDataType getFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public boolean valuesOrdered() {
        return true;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode);
    }

    @Override
    public void clear() {
    }

    @Override
    public void clear(IndexReader reader) {
    }

    @Override
    public AtomicFieldData.WithOrdinals<ScriptDocValues> load(AtomicReaderContext context) {
        return new IndexAtomicFieldData(this.index().name());
    }

    @Override
    public AtomicFieldData.WithOrdinals<ScriptDocValues> loadDirect(AtomicReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexFieldData.WithOrdinals<?> loadGlobal(IndexReader indexReader) {
        return this;
    }

    @Override
    public IndexFieldData.WithOrdinals<?> localGlobalDirect(IndexReader indexReader) throws Exception {
        return this.loadGlobal(indexReader);
    }

    private static class IndexAtomicFieldData
    implements AtomicFieldData.WithOrdinals<ScriptDocValues> {
        private final String index;

        IndexAtomicFieldData(String index) {
            this.index = index;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return 1L;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
            return new IndexBytesValues(this.index);
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return new ScriptDocValues.Strings(this.getBytesValues(false));
        }

        @Override
        public void close() {
        }

        @Override
        public TermsEnum getTermsEnum() {
            return new AtomicFieldDataWithOrdinalsTermsEnum(this);
        }
    }

    private static class IndexBytesValues
    extends BytesValues.WithOrdinals {
        final int hash;

        protected IndexBytesValues(String index) {
            super(INDEX_ORDINALS);
            this.scratch.copyChars(index);
            this.hash = this.scratch.hashCode();
        }

        @Override
        public int currentValueHash() {
            return this.hash;
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            return this.scratch;
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService, GlobalOrdinalsBuilder globalOrdinalBuilder) {
            return new IndexIndexFieldData(index, mapper.names());
        }
    }
}

