/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.packed.AppendingPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class InternalGlobalOrdinalsBuilder
extends AbstractIndexComponent
implements GlobalOrdinalsBuilder {
    public static final int ORDINAL_MAPPING_THRESHOLD_DEFAULT = 2048;
    public static final String ORDINAL_MAPPING_THRESHOLD_KEY = "global_ordinals_compress_threshold";
    public static final String ORDINAL_MAPPING_THRESHOLD_INDEX_SETTING_KEY = "index.global_ordinals_compress_threshold";

    public InternalGlobalOrdinalsBuilder(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public IndexFieldData.WithOrdinals build(IndexReader indexReader, IndexFieldData.WithOrdinals indexFieldData, Settings settings, CircuitBreakerService breakerService) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTime = System.currentTimeMillis();
        float acceptableOverheadRatio = settings.getAsFloat("acceptable_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        AppendingPackedLongBuffer globalOrdToFirstSegment = new AppendingPackedLongBuffer(0.0f);
        MonotonicAppendingLongBuffer globalOrdToFirstSegmentDelta = new MonotonicAppendingLongBuffer(0.0f);
        FieldDataType fieldDataType = indexFieldData.getFieldDataType();
        int defaultThreshold = settings.getAsInt(ORDINAL_MAPPING_THRESHOLD_INDEX_SETTING_KEY, (Integer)2048);
        int threshold = fieldDataType.getSettings().getAsInt(ORDINAL_MAPPING_THRESHOLD_KEY, (Integer)defaultThreshold);
        OrdinalMappingSourceBuilder ordinalMappingBuilder = new OrdinalMappingSourceBuilder(indexReader.leaves().size(), acceptableOverheadRatio, threshold);
        long currentGlobalOrdinal = 0L;
        AtomicFieldData.WithOrdinals[] withOrdinals = new AtomicFieldData.WithOrdinals[indexReader.leaves().size()];
        TermIterator termIterator = new TermIterator(indexFieldData, indexReader.leaves(), withOrdinals);
        BytesRef term = termIterator.next();
        while (term != null) {
            globalOrdToFirstSegment.add(termIterator.firstReaderIndex());
            long globalOrdinalDelta = currentGlobalOrdinal - termIterator.firstLocalOrdinal();
            globalOrdToFirstSegmentDelta.add(globalOrdinalDelta);
            for (TermIterator.LeafSource leafSource : termIterator.competitiveLeafs()) {
                ordinalMappingBuilder.onOrdinal(leafSource.context.ord, leafSource.tenum.ord(), currentGlobalOrdinal);
            }
            ++currentGlobalOrdinal;
            term = termIterator.next();
        }
        long memorySizeInBytesCounter = 0L;
        globalOrdToFirstSegment.freeze();
        memorySizeInBytesCounter += globalOrdToFirstSegment.ramBytesUsed();
        globalOrdToFirstSegmentDelta.freeze();
        memorySizeInBytesCounter += globalOrdToFirstSegmentDelta.ramBytesUsed();
        long maxOrd = currentGlobalOrdinal;
        OrdinalMappingSource[] segmentOrdToGlobalOrdLookups = ordinalMappingBuilder.build(maxOrd);
        long memorySizeInBytes = memorySizeInBytesCounter += ordinalMappingBuilder.getMemorySizeInBytes();
        breakerService.getBreaker().addWithoutBreaking(memorySizeInBytes);
        if (this.logger.isDebugEnabled()) {
            String implName = segmentOrdToGlobalOrdLookups.getClass().getSimpleName();
            this.logger.debug("Global-ordinals[{}][{}][{}] took {} ms", implName, indexFieldData.getFieldNames().fullName(), maxOrd, System.currentTimeMillis() - startTime);
        }
        return new InternalGlobalOrdinalsIndexFieldData(indexFieldData.index(), settings, indexFieldData.getFieldNames(), fieldDataType, withOrdinals, globalOrdToFirstSegment, globalOrdToFirstSegmentDelta, segmentOrdToGlobalOrdLookups, memorySizeInBytes);
    }

    private static final class TermIterator
    implements BytesRefIterator {
        private final LeafSourceQueue sources;
        private final List<LeafSource> competitiveLeafs = new ArrayList<LeafSource>();

        private TermIterator(IndexFieldData.WithOrdinals indexFieldData, List<AtomicReaderContext> leaves, AtomicFieldData.WithOrdinals[] withOrdinals) throws IOException {
            this.sources = new LeafSourceQueue(leaves.size());
            for (int i = 0; i < leaves.size(); ++i) {
                AtomicReaderContext atomicReaderContext = leaves.get(i);
                Object afd = indexFieldData.load(atomicReaderContext);
                withOrdinals[i] = afd;
                LeafSource leafSource = new LeafSource((AtomicFieldData.WithOrdinals)afd, atomicReaderContext);
                if (leafSource.current == null) continue;
                this.sources.add(leafSource);
            }
        }

        @Override
        public BytesRef next() throws IOException {
            for (LeafSource top : this.competitiveLeafs) {
                if (top.next() == null) continue;
                this.sources.add(top);
            }
            this.competitiveLeafs.clear();
            if (this.sources.size() == 0) {
                return null;
            }
            do {
                LeafSource competitiveLeaf = (LeafSource)this.sources.pop();
                this.competitiveLeafs.add(competitiveLeaf);
            } while (this.sources.size() > 0 && this.competitiveLeafs.get((int)0).current.equals(((LeafSource)this.sources.top()).current));
            return this.competitiveLeafs.get((int)0).current;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        List<LeafSource> competitiveLeafs() throws IOException {
            return this.competitiveLeafs;
        }

        int firstReaderIndex() {
            return this.competitiveLeafs.get((int)0).context.ord;
        }

        long firstLocalOrdinal() throws IOException {
            return this.competitiveLeafs.get((int)0).tenum.ord();
        }

        private static final class LeafSourceQueue
        extends PriorityQueue<LeafSource> {
            private final Comparator<BytesRef> termComp = BytesRef.getUTF8SortedAsUnicodeComparator();

            LeafSourceQueue(int size) {
                super(size);
            }

            @Override
            protected boolean lessThan(LeafSource termsA, LeafSource termsB) {
                int cmp = this.termComp.compare(termsA.current, termsB.current);
                if (cmp != 0) {
                    return cmp < 0;
                }
                return termsA.context.ord < termsB.context.ord;
            }
        }

        private static class LeafSource {
            final TermsEnum tenum;
            final AtomicReaderContext context;
            BytesRef current;

            private LeafSource(AtomicFieldData.WithOrdinals afd, AtomicReaderContext context) throws IOException {
                this.tenum = afd.getTermsEnum();
                this.context = context;
                this.current = this.tenum.next();
            }

            BytesRef next() throws IOException {
                this.current = this.tenum.next();
                return this.current;
            }
        }
    }

    private static final class PackedIntOrdinalMappingSource
    implements OrdinalMappingSource {
        private final PackedInts.Reader segmentOrdToGlobalOrdLookup;
        private final long memorySizeInBytes;
        private final long maxOrd;

        private PackedIntOrdinalMappingSource(PackedInts.Reader segmentOrdToGlobalOrdLookup, long memorySizeInBytes, long maxOrd) {
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            this.memorySizeInBytes = memorySizeInBytes;
            this.maxOrd = maxOrd;
        }

        @Override
        public Ordinals.Docs globalOrdinals(Ordinals.Docs segmentOrdinals) {
            return new GlobalOrdinalsDocs(segmentOrdinals, this.memorySizeInBytes, this.maxOrd, this.segmentOrdToGlobalOrdLookup);
        }

        private static final class GlobalOrdinalsDocs
        extends GlobalOrdinalMapping {
            private final PackedInts.Reader segmentOrdToGlobalOrdLookup;

            private GlobalOrdinalsDocs(Ordinals.Docs segmentOrdinals, long memorySizeInBytes, long maxOrd, PackedInts.Reader segmentOrdToGlobalOrdLookup) {
                super(segmentOrdinals, memorySizeInBytes, maxOrd);
                this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            }

            @Override
            public long getGlobalOrd(long segmentOrd) {
                return segmentOrd + this.segmentOrdToGlobalOrdLookup.get((int)segmentOrd);
            }
        }
    }

    private static final class CompressedOrdinalMappingSource
    implements OrdinalMappingSource {
        private final MonotonicAppendingLongBuffer globalOrdinalMapping;
        private final long memorySizeInBytes;
        private final long maxOrd;

        private CompressedOrdinalMappingSource(MonotonicAppendingLongBuffer globalOrdinalMapping, long memorySizeInBytes, long maxOrd) {
            this.globalOrdinalMapping = globalOrdinalMapping;
            this.memorySizeInBytes = memorySizeInBytes;
            this.maxOrd = maxOrd;
        }

        @Override
        public Ordinals.Docs globalOrdinals(Ordinals.Docs segmentOrdinals) {
            return new GlobalOrdinalsDocs(segmentOrdinals, this.globalOrdinalMapping, this.memorySizeInBytes, this.maxOrd);
        }

        private static final class GlobalOrdinalsDocs
        extends GlobalOrdinalMapping {
            private final MonotonicAppendingLongBuffer segmentOrdToGlobalOrdLookup;

            private GlobalOrdinalsDocs(Ordinals.Docs segmentOrdinals, MonotonicAppendingLongBuffer segmentOrdToGlobalOrdLookup, long memorySizeInBytes, long maxOrd) {
                super(segmentOrdinals, memorySizeInBytes, maxOrd);
                this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            }

            @Override
            public long getGlobalOrd(long segmentOrd) {
                return segmentOrd + this.segmentOrdToGlobalOrdLookup.get(segmentOrd);
            }
        }
    }

    private static final class OrdinalMappingSourceBuilder {
        final MonotonicAppendingLongBuffer[] segmentOrdToGlobalOrdDeltas;
        final float acceptableOverheadRatio;
        final int numSegments;
        final int threshold;
        long memorySizeInBytesCounter;

        private OrdinalMappingSourceBuilder(int numSegments, float acceptableOverheadRatio, int threshold) {
            this.segmentOrdToGlobalOrdDeltas = new MonotonicAppendingLongBuffer[numSegments];
            for (int i = 0; i < this.segmentOrdToGlobalOrdDeltas.length; ++i) {
                this.segmentOrdToGlobalOrdDeltas[i] = new MonotonicAppendingLongBuffer(acceptableOverheadRatio);
            }
            this.numSegments = numSegments;
            this.acceptableOverheadRatio = acceptableOverheadRatio;
            this.threshold = threshold;
        }

        public void onOrdinal(int readerIndex, long segmentOrdinal, long globalOrdinal) {
            long delta = globalOrdinal - segmentOrdinal;
            this.segmentOrdToGlobalOrdDeltas[readerIndex].add(delta);
        }

        public OrdinalMappingSource[] build(long maxOrd) {
            if (maxOrd <= (long)this.threshold) {
                PackedInts.Mutable[] newSegmentOrdToGlobalOrdDeltas = new PackedInts.Mutable[this.numSegments];
                for (int i = 0; i < this.segmentOrdToGlobalOrdDeltas.length; ++i) {
                    newSegmentOrdToGlobalOrdDeltas[i] = PackedInts.getMutable((int)this.segmentOrdToGlobalOrdDeltas[i].size(), PackedInts.bitsRequired(maxOrd), this.acceptableOverheadRatio);
                }
                for (int readerIndex = 0; readerIndex < this.segmentOrdToGlobalOrdDeltas.length; ++readerIndex) {
                    MonotonicAppendingLongBuffer segmentOrdToGlobalOrdDelta = this.segmentOrdToGlobalOrdDeltas[readerIndex];
                    for (long ordIndex = 0L; ordIndex < segmentOrdToGlobalOrdDelta.size(); ++ordIndex) {
                        long ordDelta = segmentOrdToGlobalOrdDelta.get(ordIndex);
                        newSegmentOrdToGlobalOrdDeltas[readerIndex].set((int)ordIndex, ordDelta);
                    }
                }
                OrdinalMappingSource[] sources = new PackedIntOrdinalMappingSource[this.numSegments];
                for (int i = 0; i < newSegmentOrdToGlobalOrdDeltas.length; ++i) {
                    PackedInts.Mutable segmentOrdToGlobalOrdDelta = newSegmentOrdToGlobalOrdDeltas[i];
                    if ((long)segmentOrdToGlobalOrdDelta.size() == maxOrd) {
                        sources[i] = null;
                        continue;
                    }
                    long ramUsed = segmentOrdToGlobalOrdDelta.ramBytesUsed();
                    sources[i] = new PackedIntOrdinalMappingSource(segmentOrdToGlobalOrdDelta, ramUsed, maxOrd);
                    this.memorySizeInBytesCounter += ramUsed;
                }
                return sources;
            }
            OrdinalMappingSource[] sources = new OrdinalMappingSource[this.segmentOrdToGlobalOrdDeltas.length];
            for (int i = 0; i < this.segmentOrdToGlobalOrdDeltas.length; ++i) {
                MonotonicAppendingLongBuffer segmentOrdToGlobalOrdLookup = this.segmentOrdToGlobalOrdDeltas[i];
                if (segmentOrdToGlobalOrdLookup.size() == maxOrd) {
                    sources[i] = null;
                    continue;
                }
                segmentOrdToGlobalOrdLookup.freeze();
                long ramUsed = segmentOrdToGlobalOrdLookup.ramBytesUsed();
                sources[i] = new CompressedOrdinalMappingSource(segmentOrdToGlobalOrdLookup, ramUsed, maxOrd);
                this.memorySizeInBytesCounter += ramUsed;
            }
            return sources;
        }

        public long getMemorySizeInBytes() {
            return this.memorySizeInBytesCounter;
        }
    }

    public static abstract class GlobalOrdinalMapping
    implements Ordinals.Docs {
        protected final Ordinals.Docs segmentOrdinals;
        private final long memorySizeInBytes;
        protected final long maxOrd;
        protected long currentGlobalOrd;

        private GlobalOrdinalMapping(Ordinals.Docs segmentOrdinals, long memorySizeInBytes, long maxOrd) {
            this.segmentOrdinals = segmentOrdinals;
            this.memorySizeInBytes = memorySizeInBytes;
            this.maxOrd = maxOrd;
        }

        @Override
        public final long getMaxOrd() {
            return this.maxOrd;
        }

        @Override
        public final boolean isMultiValued() {
            return this.segmentOrdinals.isMultiValued();
        }

        @Override
        public final int setDocument(int docId) {
            return this.segmentOrdinals.setDocument(docId);
        }

        @Override
        public final long currentOrd() {
            return this.currentGlobalOrd;
        }

        @Override
        public final long getOrd(int docId) {
            long segmentOrd = this.segmentOrdinals.getOrd(docId);
            if (segmentOrd == -1L) {
                this.currentGlobalOrd = -1L;
                return -1L;
            }
            this.currentGlobalOrd = this.getGlobalOrd(segmentOrd);
            return this.currentGlobalOrd;
        }

        @Override
        public final long nextOrd() {
            long segmentOrd = this.segmentOrdinals.nextOrd();
            this.currentGlobalOrd = this.getGlobalOrd(segmentOrd);
            return this.currentGlobalOrd;
        }

        public abstract long getGlobalOrd(long var1);
    }

    public static interface OrdinalMappingSource {
        public Ordinals.Docs globalOrdinals(Ordinals.Docs var1);
    }
}

